/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.api;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.api.HugeWeightMapping;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.GraphDimensions;
import org.neo4j.graphalgo.core.HugeNullWeightMap;
import org.neo4j.graphalgo.core.HugeWeightMap;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.NodeImporter;
import org.neo4j.graphalgo.core.NullWeightMap;
import org.neo4j.graphalgo.core.WeightMap;
import org.neo4j.graphalgo.core.huge.HugeIdMap;
import org.neo4j.graphalgo.core.huge.HugeNodeImporter;
import org.neo4j.graphalgo.core.utils.ImportProgress;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLoggerAdapter;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public abstract class GraphFactory {
    public static final String TASK_LOADING = "LOADING";
    protected final ExecutorService threadPool;
    protected final GraphDatabaseAPI api;
    protected final GraphSetup setup;
    protected final GraphDimensions dimensions;
    protected final ImportProgress progress;
    protected Log log = NullLog.getInstance();
    protected ProgressLogger progressLogger = ProgressLogger.NULL_LOGGER;

    public GraphFactory(GraphDatabaseAPI api, GraphSetup setup) {
        this.threadPool = setup.executor;
        this.api = api;
        this.setup = setup;
        this.log = setup.log;
        this.progressLogger = GraphFactory.progressLogger(this.log, setup.logMillis, TimeUnit.MILLISECONDS);
        this.dimensions = (GraphDimensions)new GraphDimensions(api, setup).call();
        this.progress = new ImportProgress(this.progressLogger, setup.tracker, this.dimensions.hugeNodeCount(), this.dimensions.maxRelCount(), setup.loadIncoming, setup.loadOutgoing);
    }

    public abstract Graph build();

    protected IdMap loadIdMap() throws EntityNotFoundException {
        NodeImporter nodeImporter = new NodeImporter(this.api, this.progress, this.dimensions.nodeCount(), this.dimensions.labelId());
        return (IdMap)nodeImporter.call();
    }

    protected HugeIdMap loadHugeIdMap(AllocationTracker tracker) throws EntityNotFoundException {
        HugeNodeImporter nodeImporter = new HugeNodeImporter(this.api, tracker, this.progress, this.dimensions.hugeNodeCount(), this.dimensions.allNodesCount(), this.dimensions.labelId());
        return (HugeIdMap)nodeImporter.call();
    }

    protected WeightMapping newWeightMap(int propertyId, double defaultValue) {
        return propertyId == -1 ? new NullWeightMap(defaultValue) : new WeightMap(this.dimensions.nodeCount(), defaultValue, propertyId);
    }

    protected HugeWeightMapping hugeWeightMapping(AllocationTracker tracker, int propertyId, double defaultValue) {
        return propertyId == -1 ? new HugeNullWeightMap(defaultValue) : new HugeWeightMap(this.dimensions.hugeNodeCount(), defaultValue, tracker);
    }

    private static ProgressLogger progressLogger(Log log, long time, TimeUnit unit) {
        if (log == NullLog.getInstance()) {
            return ProgressLogger.NULL_LOGGER;
        }
        ProgressLoggerAdapter logger = new ProgressLoggerAdapter(log, TASK_LOADING);
        if (time > 0L) {
            logger.withLogIntervalMillis((int)Math.min(unit.toMillis(time), Integer.MAX_VALUE));
        }
        return logger;
    }
}

