/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.api;

import java.util.concurrent.ExecutorService;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphdb.Direction;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class GraphSetup {
    public final String startLabel;
    public final String endLabel;
    public final String relationshipType;
    public final boolean loadIncoming;
    public final boolean loadOutgoing;
    public final String relationWeightPropertyName;
    public final double relationDefaultWeight;
    public final String nodeWeightPropertyName;
    public final double nodeDefaultWeight;
    public final String nodePropertyName;
    public final double nodeDefaultPropertyValue;
    public final Log log;
    public final long logMillis;
    public final AllocationTracker tracker;
    public final ExecutorService executor;
    public final int concurrency;
    public final int batchSize;
    public final boolean accumulateWeights;

    public GraphSetup(String startLabel, String endLabel, String relationshipType, Direction direction, String relationWeightPropertyName, double relationDefaultWeight, String nodeWeightPropertyName, double nodeDefaultWeight, String nodePropertyName, double nodeDefaultPropertyValue, ExecutorService executor, int concurrency, int batchSize, boolean accumulateWeights, Log log, long logMillis, AllocationTracker tracker) {
        this.startLabel = startLabel;
        this.endLabel = endLabel;
        this.relationshipType = relationshipType;
        this.loadIncoming = direction == Direction.INCOMING || direction == Direction.BOTH;
        this.loadOutgoing = direction == Direction.OUTGOING || direction == Direction.BOTH;
        this.relationWeightPropertyName = relationWeightPropertyName;
        this.relationDefaultWeight = relationDefaultWeight;
        this.nodeWeightPropertyName = nodeWeightPropertyName;
        this.nodeDefaultWeight = nodeDefaultWeight;
        this.nodePropertyName = nodePropertyName;
        this.nodeDefaultPropertyValue = nodeDefaultPropertyValue;
        this.executor = executor;
        this.concurrency = concurrency;
        this.batchSize = batchSize;
        this.accumulateWeights = accumulateWeights;
        this.log = log;
        this.logMillis = logMillis;
        this.tracker = tracker;
    }

    public GraphSetup() {
        this.startLabel = null;
        this.endLabel = null;
        this.relationshipType = null;
        this.loadOutgoing = true;
        this.loadIncoming = true;
        this.relationWeightPropertyName = null;
        this.relationDefaultWeight = 1.0;
        this.nodeWeightPropertyName = null;
        this.nodeDefaultWeight = 1.0;
        this.nodePropertyName = null;
        this.nodeDefaultPropertyValue = 1.0;
        this.executor = null;
        this.concurrency = Pools.DEFAULT_CONCURRENCY;
        this.batchSize = -1;
        this.accumulateWeights = false;
        this.log = NullLog.getInstance();
        this.logMillis = -1L;
        this.tracker = AllocationTracker.EMPTY;
    }

    public GraphSetup(ExecutorService executor) {
        this.startLabel = null;
        this.endLabel = null;
        this.relationshipType = null;
        this.loadOutgoing = true;
        this.loadIncoming = true;
        this.relationWeightPropertyName = null;
        this.relationDefaultWeight = 1.0;
        this.nodeWeightPropertyName = null;
        this.nodeDefaultWeight = 1.0;
        this.nodePropertyName = null;
        this.nodeDefaultPropertyValue = 1.0;
        this.executor = executor;
        this.concurrency = Pools.DEFAULT_CONCURRENCY;
        this.batchSize = -1;
        this.accumulateWeights = false;
        this.log = NullLog.getInstance();
        this.logMillis = -1L;
        this.tracker = AllocationTracker.EMPTY;
    }

    public boolean loadConcurrent() {
        return this.executor != null;
    }

    public int concurrency() {
        if (!this.loadConcurrent()) {
            return 1;
        }
        return this.concurrency;
    }

    public boolean loadDefaultRelationshipWeight() {
        return this.relationWeightPropertyName == null;
    }

    public boolean loadDefaultNodeWeight() {
        return this.nodeWeightPropertyName == null;
    }

    public boolean loadDefaultNodeProperty() {
        return this.nodePropertyName == null;
    }

    public boolean loadAnyLabel() {
        return this.startLabel == null;
    }

    public boolean loadAnyRelationshipType() {
        return this.relationshipType == null;
    }
}

