/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.api;

import java.util.Collection;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.HugeBatchNodeIterable;
import org.neo4j.graphalgo.api.HugeDegrees;
import org.neo4j.graphalgo.api.HugeIdMapping;
import org.neo4j.graphalgo.api.HugeNodeIterator;
import org.neo4j.graphalgo.api.HugeRelationshipIterator;
import org.neo4j.graphalgo.api.HugeRelationshipWeights;
import org.neo4j.graphdb.Direction;

public interface HugeGraph
extends HugeIdMapping,
HugeDegrees,
HugeNodeIterator,
HugeBatchNodeIterable,
HugeRelationshipIterator,
HugeRelationshipWeights,
Graph {
    @Override
    default public void release() {
    }

    @Override
    default public Collection<PrimitiveIntIterable> batchIterables(int batchSize) {
        return this.hugeBatchIterables(batchSize).stream().map(l -> () -> new LongToIntIterator(l.iterator())).collect(Collectors.toList());
    }

    @Override
    default public int degree(int nodeId, Direction direction) {
        return this.degree((long)nodeId, direction);
    }

    @Override
    default public int toMappedNodeId(long nodeId) {
        return (int)this.toHugeMappedNodeId(nodeId);
    }

    @Override
    default public long toOriginalNodeId(int nodeId) {
        return this.toOriginalNodeId((long)nodeId);
    }

    @Override
    default public void forEachNode(IntPredicate consumer) {
        this.forEachNode((long l) -> consumer.test((int)l));
    }

    @Override
    default public PrimitiveIntIterator nodeIterator() {
        return new LongToIntIterator(this.hugeNodeIterator());
    }

    public static final class LongToIntIterator
    implements PrimitiveIntIterator {
        private final PrimitiveLongIterator iter;

        LongToIntIterator(PrimitiveLongIterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public int next() {
            return (int)this.iter.next();
        }
    }
}

