/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.core.utils.StatementTask;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class GraphDimensions
extends StatementTask<GraphDimensions, RuntimeException> {
    private final GraphSetup setup;
    private long nodeCount;
    private long allNodesCount;
    private long maxRelCount;
    private int labelId;
    private int[] relationId;
    private int weightId;
    private int relWeightId;
    private int nodeWeightId;
    private int nodePropId;

    public GraphDimensions(GraphDatabaseAPI api, GraphSetup setup) {
        super(api);
        this.setup = setup;
    }

    public long hugeNodeCount() {
        return this.nodeCount;
    }

    public long allNodesCount() {
        return this.allNodesCount;
    }

    public int nodeCount() {
        return Math.toIntExact(this.nodeCount);
    }

    public long maxRelCount() {
        return this.maxRelCount;
    }

    public int labelId() {
        return this.labelId;
    }

    public int[] relationId() {
        return this.relationId;
    }

    public int weightId() {
        return this.weightId;
    }

    public int relWeightId() {
        return this.relWeightId;
    }

    public int nodeWeightId() {
        return this.nodeWeightId;
    }

    public int nodePropId() {
        return this.nodePropId;
    }

    @Override
    public GraphDimensions apply(Statement statement) throws RuntimeException {
        int relId;
        ReadOperations readOp = statement.readOperations();
        int n = this.labelId = this.setup.loadAnyLabel() ? -1 : readOp.labelGetForName(this.setup.startLabel);
        if (!this.setup.loadAnyRelationshipType() && (relId = readOp.relationshipTypeGetForName(this.setup.relationshipType)) != -1) {
            this.relationId = new int[]{relId};
        }
        this.weightId = this.setup.loadDefaultRelationshipWeight() ? -1 : readOp.propertyKeyGetForName(this.setup.relationWeightPropertyName);
        this.relWeightId = this.setup.loadDefaultRelationshipWeight() ? -1 : readOp.propertyKeyGetForName(this.setup.relationWeightPropertyName);
        this.nodeWeightId = this.setup.loadDefaultNodeWeight() ? -1 : readOp.propertyKeyGetForName(this.setup.nodeWeightPropertyName);
        this.nodePropId = this.setup.loadDefaultNodeProperty() ? -1 : readOp.propertyKeyGetForName(this.setup.nodePropertyName);
        this.nodeCount = readOp.countsForNode(this.labelId);
        this.allNodesCount = readOp.nodesGetCount();
        this.maxRelCount = Math.max(readOp.countsForRelationshipWithoutTxState(this.labelId, this.relationId == null ? -1 : this.relationId[0], -1), readOp.countsForRelationshipWithoutTxState(-1, this.relationId == null ? -1 : this.relationId[0], this.labelId));
        return this;
    }
}

