/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class GraphLoader {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodType CTOR_METHOD = MethodType.methodType(Void.TYPE, GraphDatabaseAPI.class, GraphSetup.class);
    private String label = null;
    private String relation = null;
    private String relWeightProp = null;
    private String nodeWeightProp = null;
    private String nodeProp = null;
    private Direction direction = Direction.BOTH;
    private final GraphDatabaseAPI api;
    private ExecutorService executorService;
    private double relWeightDefault = 0.0;
    private double nodeWeightDefault = 0.0;
    private double nodePropDefault = 0.0;
    private int batchSize = 10000;
    private int concurrency = Pools.DEFAULT_CONCURRENCY;
    private boolean accumulateWeights;
    private Log log = NullLog.getInstance();
    private long logMillis = -1L;
    private AllocationTracker tracker = AllocationTracker.EMPTY;

    public GraphLoader(GraphDatabaseAPI api) {
        this.api = Objects.requireNonNull(api);
        this.executorService = null;
    }

    public GraphLoader(GraphDatabaseAPI api, ExecutorService executorService) {
        this.api = Objects.requireNonNull(api);
        this.executorService = Objects.requireNonNull(executorService);
    }

    public GraphLoader withLog(Log log) {
        this.log = log;
        return this;
    }

    public GraphLoader withLogInterval(long value, TimeUnit unit) {
        this.logMillis = unit.toMillis(value);
        return this;
    }

    public GraphLoader withDefaultLogInterval() {
        this.logMillis = -1L;
        return this;
    }

    public GraphLoader withAllocationTracker(AllocationTracker tracker) {
        this.tracker = tracker;
        return this;
    }

    public GraphLoader withExecutorService(ExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService);
        return this;
    }

    public GraphLoader withoutExecutorService() {
        this.executorService = null;
        return this;
    }

    public GraphLoader withConcurrency(int newConcurrency) {
        if (newConcurrency <= 0) {
            throw new IllegalArgumentException("concurrency: " + newConcurrency);
        }
        this.concurrency = newConcurrency;
        return this;
    }

    public GraphLoader withDefaultConcurrency() {
        this.concurrency = Pools.DEFAULT_CONCURRENCY;
        return this;
    }

    public GraphLoader withLabel(String label) {
        this.label = Objects.requireNonNull(label);
        return this;
    }

    public GraphLoader withOptionalLabel(String label) {
        this.label = label;
        return this;
    }

    public GraphLoader withLabel(Label label) {
        this.label = Objects.requireNonNull(label).name();
        return this;
    }

    public GraphLoader withAnyLabel() {
        this.label = null;
        return this;
    }

    public GraphLoader withRelationshipType(String relation) {
        this.relation = Objects.requireNonNull(relation);
        return this;
    }

    public GraphLoader withOptionalRelationshipType(String relation) {
        this.relation = relation;
        return this;
    }

    public GraphLoader withRelationshipType(RelationshipType relation) {
        this.relation = Objects.requireNonNull(relation).name();
        return this;
    }

    public GraphLoader withAnyRelationshipType() {
        this.relation = null;
        return this;
    }

    public GraphLoader withDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public GraphLoader withRelationshipWeightsFromProperty(String property, double propertyDefaultValue) {
        this.relWeightProp = Objects.requireNonNull(property);
        this.relWeightDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withOptionalRelationshipWeightsFromProperty(String property, double propertyDefaultValue) {
        this.relWeightProp = property;
        this.relWeightDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withNodeWeightsFromProperty(String property, double propertyDefaultValue) {
        this.nodeWeightProp = Objects.requireNonNull(property);
        this.nodeWeightDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withOptionalNodeWeightsFromProperty(String property, double propertyDefaultValue) {
        this.nodeWeightProp = property;
        this.nodeWeightDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withNodeProperty(String property, double propertyDefaultValue) {
        this.nodeProp = Objects.requireNonNull(property);
        this.nodePropDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withOptionalNodeProperty(String property, double propertyDefaultValue) {
        this.nodeProp = property;
        this.nodePropDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withDefaultRelationshipWeight(double propertyDefaultValue) {
        this.relWeightProp = null;
        this.relWeightDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withDefaultNodeWeight(double propertyDefaultValue) {
        this.nodeWeightProp = null;
        this.nodeWeightDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withDefaultNodeProperties(double propertyDefaultValue) {
        this.nodeProp = null;
        this.nodePropDefault = propertyDefaultValue;
        return this;
    }

    public GraphLoader withoutRelationshipWeights() {
        this.relWeightProp = null;
        this.relWeightDefault = 0.0;
        return this;
    }

    public GraphLoader withoutNodeWeights() {
        this.nodeWeightProp = null;
        this.nodeWeightDefault = 0.0;
        return this;
    }

    public GraphLoader withoutNodeProperties() {
        this.nodeProp = null;
        this.nodePropDefault = 0.0;
        return this;
    }

    public Graph load(Class<? extends GraphFactory> factoryType) {
        MethodHandle constructor = this.findConstructor(factoryType);
        return this.invokeConstructor(constructor).build();
    }

    private MethodHandle findConstructor(Class<?> factoryType) {
        try {
            return LOOKUP.findConstructor(factoryType, CTOR_METHOD);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private GraphFactory invokeConstructor(MethodHandle constructor) {
        GraphSetup setup = new GraphSetup(this.label, null, this.relation, this.direction, this.relWeightProp, this.relWeightDefault, this.nodeWeightProp, this.nodeWeightDefault, this.nodeProp, this.nodePropDefault, this.executorService, this.concurrency, this.batchSize, this.accumulateWeights, this.log, this.logMillis, this.tracker);
        try {
            return constructor.invoke(this.api, setup);
        }
        catch (Throwable throwable) {
            throw Exceptions.launderedException((String)throwable.getMessage(), (Throwable)throwable);
        }
    }

    public GraphLoader withNodeStatement(String nodeStatement) {
        this.label = nodeStatement;
        return this;
    }

    public GraphLoader withRelationshipStatement(String relationshipStatement) {
        this.relation = relationshipStatement;
        return this;
    }

    public GraphLoader withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public GraphLoader withAccumulateWeights(boolean accumulateWeights) {
        this.accumulateWeights = accumulateWeights;
        return this;
    }
}

