/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import org.neo4j.graphalgo.api.HugeWeightMapping;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongLongDoubleMap;

public final class HugeWeightMap
implements HugeWeightMapping {
    private HugeLongLongDoubleMap weights;
    private final double defaultValue;

    public HugeWeightMap(long capacity, double defaultValue, AllocationTracker tracker) {
        this.defaultValue = defaultValue;
        this.weights = HugeLongLongDoubleMap.newMap(capacity, tracker);
    }

    @Override
    public double weight(long source, long target) {
        return this.weights.getOrDefault(source, target, this.defaultValue);
    }

    @Override
    public double weight(long source, long target, double defaultValue) {
        return this.weights.getOrDefault(source, target, defaultValue);
    }

    public void put(long key1, long key2, Object value) {
        double doubleVal = RawValues.extractValue(value, this.defaultValue);
        if (doubleVal == this.defaultValue) {
            return;
        }
        this.weights.put(key1, key2, doubleVal);
    }

    @Override
    public long release() {
        if (this.weights != null) {
            long freed = this.weights.release();
            this.weights = null;
            return freed;
        }
        return 0L;
    }
}

