/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.LongIntMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.BatchNodeIterable;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.NodeIterator;
import org.neo4j.graphalgo.core.utils.ParallelUtil;

public final class IdMap
implements IdMapping,
NodeIterator,
BatchNodeIterable {
    private final IdIterator iter;
    private int nextGraphId;
    private long[] graphIds;
    private LongIntMap nodeToGraphIds;

    public IdMap(int capacity) {
        this.nodeToGraphIds = new LongIntHashMap((int)Math.ceil((double)capacity / 0.99), 0.99);
        this.iter = new IdIterator();
    }

    public IdMap(long[] graphIds, LongIntMap nodeToGraphIds) {
        this.nextGraphId = graphIds.length;
        this.graphIds = graphIds;
        this.nodeToGraphIds = nodeToGraphIds;
        this.iter = new IdIterator();
    }

    public PrimitiveIntIterator iterator() {
        return this.iter.reset(this.nextGraphId);
    }

    public int mapOrGet(long longValue) {
        int intValue = this.nodeToGraphIds.getOrDefault(longValue, -1);
        if (intValue == -1) {
            intValue = this.nextGraphId++;
            this.nodeToGraphIds.put(longValue, intValue);
        }
        return intValue;
    }

    public void add(long longValue) {
        int intValue = this.nextGraphId++;
        this.nodeToGraphIds.put(longValue, intValue);
    }

    public int get(long longValue) {
        return this.nodeToGraphIds.getOrDefault(longValue, -1);
    }

    public void buildMappedIds() {
        this.graphIds = new long[this.size()];
        for (LongIntCursor cursor : this.nodeToGraphIds) {
            this.graphIds[cursor.value] = cursor.key;
        }
    }

    public int size() {
        return this.nextGraphId;
    }

    public long[] mappedIds() {
        return this.graphIds;
    }

    public LongIntMap nodeToGraphIds() {
        return this.nodeToGraphIds;
    }

    public void forEach(IntPredicate consumer) {
        int limit = this.nextGraphId;
        for (int i = 0; i < limit; ++i) {
            if (consumer.test(i)) continue;
            return;
        }
    }

    @Override
    public int toMappedNodeId(long nodeId) {
        return this.mapOrGet(nodeId);
    }

    @Override
    public long toOriginalNodeId(int nodeId) {
        return this.graphIds[nodeId];
    }

    @Override
    public boolean contains(long nodeId) {
        return this.nodeToGraphIds.containsKey(nodeId);
    }

    @Override
    public long nodeCount() {
        return this.graphIds.length;
    }

    @Override
    public void forEachNode(IntPredicate consumer) {
        int count = this.graphIds.length;
        for (int i = 0; i < count; ++i) {
            if (consumer.test(i)) continue;
            return;
        }
    }

    @Override
    public PrimitiveIntIterator nodeIterator() {
        return new IdIterator().reset(this.graphIds.length);
    }

    @Override
    public Collection<PrimitiveIntIterable> batchIterables(int batchSize) {
        int nodeCount = this.graphIds.length;
        int numberOfBatches = ParallelUtil.threadSize(batchSize, nodeCount);
        if (numberOfBatches == 1) {
            return Collections.singleton(this::nodeIterator);
        }
        PrimitiveIntIterable[] iterators = new PrimitiveIntIterable[numberOfBatches];
        Arrays.setAll(iterators, i -> {
            int start = i * batchSize;
            int length = Math.min(batchSize, nodeCount - start);
            return new IdIterable(start, length);
        });
        return Arrays.asList(iterators);
    }

    private static final class IdIterator
    implements PrimitiveIntIterator {
        private int current;
        private int limit;

        private IdIterator() {
        }

        private PrimitiveIntIterator reset(int length) {
            return this.reset(0, length);
        }

        private PrimitiveIntIterator reset(int start, int length) {
            this.current = start;
            this.limit = start + length;
            return this;
        }

        public boolean hasNext() {
            return this.current < this.limit;
        }

        public int next() {
            return this.current++;
        }
    }

    private static final class IdIterable
    implements PrimitiveIntIterable {
        private final int start;
        private final int length;

        private IdIterable(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public PrimitiveIntIterator iterator() {
            return new IdIterator().reset(this.start, this.length);
        }
    }
}

