/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.utils.ImportProgress;
import org.neo4j.graphalgo.core.utils.StatementTask;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class NodeImporter
extends StatementTask<IdMap, EntityNotFoundException> {
    private final ImportProgress progress;
    private final int nodeCount;
    private final int labelId;

    public NodeImporter(GraphDatabaseAPI api, ImportProgress progress, int nodeCount, int labelId) {
        super(api);
        this.progress = progress;
        this.nodeCount = nodeCount;
        this.labelId = labelId;
    }

    @Override
    public IdMap apply(Statement statement) throws EntityNotFoundException {
        PrimitiveLongIterator nodeIds;
        IdMap mapping = new IdMap(this.nodeCount);
        ReadOperations readOp = statement.readOperations();
        PrimitiveLongIterator primitiveLongIterator = nodeIds = this.labelId == -1 ? readOp.nodesGetAll() : readOp.nodesGetForLabel(this.labelId);
        while (nodeIds.hasNext()) {
            mapping.add(nodeIds.next());
            this.progress.nodeProgress();
        }
        mapping.buildMappedIds();
        this.progress.resetForRelationships();
        return mapping;
    }
}

