/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.core.heavyweight.HeavyCypherGraphFactory;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraphFactory;
import org.neo4j.graphalgo.core.huge.HugeGraphFactory;
import org.neo4j.graphalgo.core.lightweight.LightGraphFactory;
import org.neo4j.graphalgo.core.neo4jview.GraphViewFactory;
import org.neo4j.graphalgo.core.utils.Directions;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphdb.Direction;

public class ProcedureConfiguration {
    private final Map<String, Object> config;

    public ProcedureConfiguration(Map<String, Object> config) {
        this.config = new HashMap<String, Object>(config);
    }

    public boolean containsKeys(String ... keys) {
        for (String key : keys) {
            if (this.config.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public ProcedureConfiguration overrideNodeLabelOrQuery(String nodeLabelOrQuery) {
        this.config.put("nodeQuery", nodeLabelOrQuery);
        return this;
    }

    public ProcedureConfiguration overrideRelationshipTypeOrQuery(String relationshipTypeOrQuery) {
        this.config.put("relationshipQuery", relationshipTypeOrQuery);
        return this;
    }

    public ProcedureConfiguration overrideDirection(String direction) {
        this.config.put("direction", direction);
        return this;
    }

    public ProcedureConfiguration overrideDirection(Direction direction) {
        this.config.put("direction", direction.name());
        return this;
    }

    public ProcedureConfiguration overrideProperty(String weightProperty) {
        this.config.put("weightProperty", weightProperty);
        return this;
    }

    public String getNodeLabelOrQuery() {
        return this.getString("nodeQuery", null);
    }

    public String getNodeLabelOrQuery(String defaultValue) {
        return this.getString("nodeQuery", defaultValue);
    }

    public String getRelationshipOrQuery() {
        return this.getString("relationshipQuery", null);
    }

    public String getWriteProperty() {
        return this.getWriteProperty("writeValue");
    }

    public String getWriteProperty(String defaultValue) {
        return this.getString("writeProperty", defaultValue);
    }

    public String getRelationshipOrQuery(String defaultValue) {
        return this.getString("relationshipQuery", defaultValue);
    }

    public boolean isWriteFlag() {
        return this.isWriteFlag(true);
    }

    public boolean isCypherFlag() {
        return this.isCypherFlag(false);
    }

    public boolean isStatsFlag() {
        return this.isStatsFlag(false);
    }

    public boolean isWriteFlag(boolean defaultValue) {
        return this.get("write", defaultValue);
    }

    public boolean isCypherFlag(boolean defaultValue) {
        return (Boolean)this.config.getOrDefault("cypher", defaultValue);
    }

    public boolean isStatsFlag(boolean defaultValue) {
        return this.get("stats", defaultValue);
    }

    public String getProperty() {
        return this.getString("weightProperty", null);
    }

    public double getPropertyDefaultValue(double defaultValue) {
        return this.get("defaultValue", defaultValue);
    }

    public int getIterations(int defaultValue) {
        return this.getNumber("iterations", defaultValue).intValue();
    }

    public int getBatchSize() {
        return this.getNumber("batchSize", 10000).intValue();
    }

    public int getBatchSize(int defaultValue) {
        return this.getNumber("batchSize", defaultValue).intValue();
    }

    public int getConcurrency(int defaultValue) {
        return this.getNumber("concurrency", defaultValue).intValue();
    }

    public int getConcurrency() {
        return this.getConcurrency(Pools.DEFAULT_CONCURRENCY);
    }

    public String getDirectionName() {
        return this.getDirectionName("BOTH");
    }

    public String getDirectionName(String defaultDirection) {
        return this.get("direction", defaultDirection);
    }

    public Direction getDirection(Direction defaultDirection) {
        return Directions.fromString(this.getDirectionName(defaultDirection.name()));
    }

    public Class<? extends GraphFactory> getGraphImpl() {
        String graphImpl = this.getString("graph", "heavy");
        switch (graphImpl.toLowerCase(Locale.ROOT)) {
            case "heavy": {
                return HeavyGraphFactory.class;
            }
            case "cypher": {
                return HeavyCypherGraphFactory.class;
            }
            case "light": {
                return LightGraphFactory.class;
            }
            case "kernel": {
                return GraphViewFactory.class;
            }
            case "huge": {
                return HugeGraphFactory.class;
            }
        }
        throw new IllegalArgumentException("Unknown impl: " + graphImpl);
    }

    public String getString(String key, String defaultValue) {
        String value = (String)this.config.getOrDefault(key, defaultValue);
        return null == value || "".equals(value) ? defaultValue : value;
    }

    public Optional<String> getString(String key) {
        if (this.config.containsKey(key)) {
            return Optional.of((String)this.get(key));
        }
        return Optional.empty();
    }

    public Object get(String key) {
        return this.config.get(key);
    }

    public Number getNumber(String key, Number defaultValue) {
        Object value = this.config.get(key);
        if (null == value) {
            return defaultValue;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("The value of " + key + " must Number type");
        }
        return (Number)value;
    }

    public int getInt(String key, int defaultValue) {
        Number value = (Number)this.config.get(key);
        if (null == value) {
            return defaultValue;
        }
        return value.intValue();
    }

    public <V> V get(String key, V defaultValue) {
        Object value = this.config.get(key);
        if (null == value) {
            return defaultValue;
        }
        return (V)value;
    }

    public static ProcedureConfiguration create(Map<String, Object> config) {
        return new ProcedureConfiguration(config);
    }
}

