/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongDoubleMap;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.utils.RawValues;

public final class WeightMap
implements WeightMapping {
    private final int capacity;
    private LongDoubleMap weights;
    private final double defaultValue;
    private final int propertyId;

    public WeightMap(int capacity, double defaultValue, int propertyId) {
        this.capacity = capacity;
        this.defaultValue = defaultValue;
        this.weights = new LongDoubleHashMap();
        this.propertyId = propertyId;
    }

    public WeightMap(int capacity, LongDoubleMap weights, double defaultValue, int propertyId) {
        this.capacity = capacity;
        this.weights = weights;
        this.defaultValue = defaultValue;
        this.propertyId = propertyId;
    }

    @Override
    public double get(long id) {
        return this.weights.getOrDefault(id, this.defaultValue);
    }

    @Override
    public double get(long id, double defaultValue) {
        return this.weights.getOrDefault(id, defaultValue);
    }

    @Override
    public void set(long id, Object value) {
        double doubleVal = RawValues.extractValue(value, this.defaultValue);
        if (doubleVal == this.defaultValue) {
            return;
        }
        this.put(id, doubleVal);
    }

    private void put(long key, double value) {
        this.weights.put(key, value);
    }

    int capacity() {
        return this.capacity;
    }

    public LongDoubleMap weights() {
        return this.weights;
    }

    public int propertyId() {
        return this.propertyId;
    }

    @Override
    public int size() {
        return this.weights.size();
    }
}

