/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.heavyweight;

import java.util.Arrays;
import java.util.function.IntPredicate;
import org.apache.lucene.util.ArrayUtil;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.NodeIterator;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.api.WeightedRelationshipConsumer;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphdb.Direction;

class AdjacencyMatrix {
    private static final int[] EMPTY_INTS = new int[0];
    final int[] outOffsets;
    final int[] inOffsets;
    final int[][] outgoing;
    final int[][] incoming;

    AdjacencyMatrix(int nodeCount) {
        this(nodeCount, true, true);
    }

    AdjacencyMatrix(int nodeCount, boolean withIncoming, boolean withOutgoing) {
        this.outOffsets = withOutgoing ? new int[nodeCount] : null;
        this.inOffsets = withIncoming ? new int[nodeCount] : null;
        this.outgoing = withOutgoing ? new int[nodeCount][] : (int[][])null;
        this.incoming = withIncoming ? new int[nodeCount][] : (int[][])null;
        if (this.outgoing != null) {
            Arrays.fill((Object[])this.outgoing, EMPTY_INTS);
        }
        if (this.incoming != null) {
            Arrays.fill((Object[])this.incoming, EMPTY_INTS);
        }
    }

    AdjacencyMatrix(int[] outOffsets, int[] inOffsets, int[][] outgoing, int[][] incoming) {
        this.outOffsets = outOffsets;
        this.inOffsets = inOffsets;
        this.outgoing = outgoing;
        this.incoming = incoming;
    }

    public void armOut(int sourceNodeId, int degree) {
        if (degree > 0) {
            this.outgoing[sourceNodeId] = Arrays.copyOf(this.outgoing[sourceNodeId], degree);
        }
    }

    public void armIn(int targetNodeId, int degree) {
        if (degree > 0) {
            this.incoming[targetNodeId] = Arrays.copyOf(this.incoming[targetNodeId], degree);
        }
    }

    public void growOut(int sourceNodeId, int length) {
        this.outgoing[sourceNodeId] = ArrayUtil.grow((int[])this.outgoing[sourceNodeId], (int)length);
    }

    public void growIn(int targetNodeId, int length) {
        this.incoming[targetNodeId] = ArrayUtil.grow((int[])this.incoming[targetNodeId], (int)length);
    }

    public void addOutgoing(int sourceNodeId, int targetNodeId) {
        int degree = this.outOffsets[sourceNodeId];
        int nextDegree = degree + 1;
        if (this.outgoing[sourceNodeId].length < nextDegree) {
            this.growOut(sourceNodeId, nextDegree);
        }
        this.outgoing[sourceNodeId][degree] = targetNodeId;
        this.outOffsets[sourceNodeId] = nextDegree;
    }

    public boolean hasOutgoing(int sourceNodeId, int targetNodeId) {
        int degree = this.outOffsets[sourceNodeId];
        int[] rels = this.outgoing[sourceNodeId];
        for (int offset = degree - 1; offset >= 0; --offset) {
            if (rels[offset] != targetNodeId) continue;
            return true;
        }
        return false;
    }

    public void addIncoming(int sourceNodeId, int targetNodeId) {
        int degree = this.inOffsets[targetNodeId];
        int nextDegree = degree + 1;
        if (this.incoming[targetNodeId].length < nextDegree) {
            this.growIn(targetNodeId, nextDegree);
        }
        this.incoming[targetNodeId][degree] = sourceNodeId;
        this.inOffsets[targetNodeId] = nextDegree;
    }

    public boolean hasIncoming(int sourceNodeId, int targetNodeId) {
        int degree = this.inOffsets[sourceNodeId];
        int[] rels = this.incoming[sourceNodeId];
        for (int offset = degree - 1; offset >= 0; --offset) {
            if (rels[offset] != targetNodeId) continue;
            return true;
        }
        return false;
    }

    public int degree(int nodeId, Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return this.outOffsets[nodeId];
            }
            case INCOMING: {
                return this.inOffsets[nodeId];
            }
        }
        return this.inOffsets[nodeId] + this.outOffsets[nodeId];
    }

    public void forEach(int nodeId, Direction direction, RelationshipConsumer consumer) {
        switch (direction) {
            case OUTGOING: {
                this.forEachOutgoing(nodeId, consumer);
                break;
            }
            case INCOMING: {
                this.forEachIncoming(nodeId, consumer);
                break;
            }
            default: {
                this.forEachIncoming(nodeId, consumer);
                this.forEachOutgoing(nodeId, consumer);
            }
        }
    }

    public void forEach(int nodeId, Direction direction, WeightMapping weights, WeightedRelationshipConsumer consumer) {
        switch (direction) {
            case OUTGOING: {
                this.forEachOutgoing(nodeId, weights, consumer);
                break;
            }
            case INCOMING: {
                this.forEachIncoming(nodeId, weights, consumer);
                break;
            }
            default: {
                this.forEachIncoming(nodeId, weights, consumer);
                this.forEachOutgoing(nodeId, weights, consumer);
            }
        }
    }

    public int capacity() {
        return this.outOffsets != null ? this.outOffsets.length : (this.inOffsets != null ? this.inOffsets.length : 0);
    }

    public void addMatrix(AdjacencyMatrix other, int offset, int length) {
        if (other.outgoing != null) {
            System.arraycopy(other.outgoing, 0, this.outgoing, offset, length);
            System.arraycopy(other.outOffsets, 0, this.outOffsets, offset, length);
        }
        if (other.incoming != null) {
            System.arraycopy(other.incoming, 0, this.incoming, offset, length);
            System.arraycopy(other.inOffsets, 0, this.inOffsets, offset, length);
        }
    }

    private void forEachOutgoing(int nodeId, RelationshipConsumer consumer) {
        int degree = this.outOffsets[nodeId];
        int[] outs = this.outgoing[nodeId];
        for (int i = 0; i < degree; ++i) {
            consumer.accept(nodeId, outs[i], RawValues.combineIntInt(nodeId, outs[i]));
        }
    }

    private void forEachIncoming(int nodeId, RelationshipConsumer consumer) {
        int degree = this.inOffsets[nodeId];
        int[] ins = this.incoming[nodeId];
        for (int i = 0; i < degree; ++i) {
            consumer.accept(nodeId, ins[i], RawValues.combineIntInt(ins[i], nodeId));
        }
    }

    private void forEachOutgoing(int nodeId, WeightMapping weights, WeightedRelationshipConsumer consumer) {
        int degree = this.outOffsets[nodeId];
        int[] outs = this.outgoing[nodeId];
        for (int i = 0; i < degree; ++i) {
            long relationId = RawValues.combineIntInt(nodeId, outs[i]);
            consumer.accept(nodeId, outs[i], relationId, weights.get(relationId));
        }
    }

    private void forEachIncoming(int nodeId, WeightMapping weights, WeightedRelationshipConsumer consumer) {
        int degree = this.inOffsets[nodeId];
        int[] ins = this.incoming[nodeId];
        for (int i = 0; i < degree; ++i) {
            long relationId = RawValues.combineIntInt(ins[i], nodeId);
            consumer.accept(nodeId, ins[i], relationId, weights.get(relationId));
        }
    }

    public NodeIterator nodesWithRelationships(Direction direction) {
        if (direction == Direction.OUTGOING) {
            return new DegreeCheckingNodeIterator(this.outOffsets);
        }
        return new DegreeCheckingNodeIterator(this.inOffsets);
    }

    private static class DegreeCheckingNodeIterator
    implements NodeIterator {
        private final int[] array;

        DegreeCheckingNodeIterator(int[] array) {
            this.array = array != null ? array : EMPTY_INTS;
        }

        @Override
        public void forEachNode(IntPredicate consumer) {
            for (int node = 0; node < this.array.length && (this.array[node] <= 0 || consumer.test(node)); ++node) {
            }
        }

        @Override
        public PrimitiveIntIterator nodeIterator() {
            return new PrimitiveIntIterator(){
                int index = this.findNext();

                public boolean hasNext() {
                    return this.index < array.length;
                }

                public int next() {
                    try {
                        int n = this.index;
                        return n;
                    }
                    finally {
                        this.index = this.findNext();
                    }
                }

                private int findNext() {
                    int length = array.length;
                    for (int n = this.index + 1; n < length; ++n) {
                        if (array[n] <= 0) continue;
                        return n;
                    }
                    return length;
                }
            };
        }
    }
}

