/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.heavyweight;

import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.NullWeightMap;
import org.neo4j.graphalgo.core.WeightMap;
import org.neo4j.graphalgo.core.heavyweight.AdjacencyMatrix;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraph;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class HeavyCypherGraphFactory
extends GraphFactory {
    private static final int NO_BATCH = -1;
    private static final int INITIAL_NODE_COUNT = 1000000;
    private static final int ESTIMATED_DEGREE = 3;
    private static final String LIMIT = "limit";
    private static final String SKIP = "skip";

    public HeavyCypherGraphFactory(GraphDatabaseAPI api, GraphSetup setup) {
        super(api, setup);
    }

    @Override
    public Graph build() {
        int batchSize = this.setup.batchSize;
        Nodes nodes = this.canBatchLoad(batchSize, this.setup.startLabel) ? this.batchLoadNodes(batchSize) : this.loadNodes(0L, -1);
        Relationships relationships = this.canBatchLoad(batchSize, this.setup.relationshipType) ? this.batchLoadRelationships(batchSize, nodes) : this.loadRelationships(0L, -1, nodes);
        return new HeavyGraph(nodes.idMap, relationships.matrix, relationships.relWeights, nodes.nodeWeights, nodes.nodeProps);
    }

    private Relationships batchLoadRelationships(int batchSize, Nodes nodes) {
        ExecutorService pool = this.setup.executor;
        int threads = this.setup.concurrency();
        boolean accumulateWeights = this.setup.accumulateWeights;
        int nodeCount = nodes.idMap.size();
        AdjacencyMatrix matrix = new AdjacencyMatrix(nodeCount);
        boolean hasRelationshipWeights = !this.setup.loadDefaultRelationshipWeight();
        WeightMapping relWeights = this.newWeightMapping(hasRelationshipWeights, this.setup.relationDefaultWeight, nodeCount * 3);
        long offset = 0L;
        long lastOffset = 0L;
        long total = 0L;
        ArrayList<Future<Relationships>> futures = new ArrayList<Future<Relationships>>(threads);
        boolean working = true;
        do {
            long skip = offset;
            futures.add(pool.submit(() -> this.loadRelationships(skip, batchSize, nodes)));
            offset += (long)batchSize;
            if (futures.size() < threads) continue;
            for (Future future : futures) {
                Relationships result = (Relationships)this.get("Error during loading relationships offset: " + (lastOffset + (long)batchSize), future);
                lastOffset = result.offset;
                total += result.rows;
                working = result.rows > 0L;
                if (!working) continue;
                WeightMapping resultWeights = hasRelationshipWeights && result.relWeights.size() > 0 ? result.relWeights : null;
                result.matrix.nodesWithRelationships(Direction.OUTGOING).forEachNode(node -> {
                    result.matrix.forEach(node, Direction.OUTGOING, (source, target, relationship) -> {
                        if (accumulateWeights) {
                            if (!matrix.hasOutgoing(source, target)) {
                                matrix.addOutgoing(source, target);
                            }
                            if (resultWeights != null) {
                                relWeights.set(relationship, (Object)(resultWeights.get(relationship) + relWeights.get(relationship, 0.0)));
                            }
                        } else {
                            matrix.addOutgoing(source, target);
                            if (resultWeights != null) {
                                relWeights.set(relationship, (Object)resultWeights.get(relationship));
                            }
                        }
                        return true;
                    });
                    return true;
                });
            }
            futures.clear();
        } while (working);
        return new Relationships(0L, total, matrix, relWeights);
    }

    private Nodes batchLoadNodes(int batchSize) {
        ExecutorService pool = this.setup.executor;
        int threads = this.setup.concurrency();
        int capacity = 10000000;
        LongIntHashMap nodeToGraphIds = new LongIntHashMap(capacity);
        boolean hasNodeWeights = !this.setup.loadDefaultNodeWeight();
        WeightMapping nodeWeights = this.newWeightMapping(hasNodeWeights, this.setup.nodeDefaultWeight, capacity);
        boolean hasNodeProperty = !this.setup.loadDefaultNodeProperty();
        WeightMapping nodeProps = this.newWeightMapping(hasNodeProperty, this.setup.nodeDefaultPropertyValue, capacity);
        long offset = 0L;
        long total = 0L;
        long lastOffset = 0L;
        ArrayList<Future<Nodes>> futures = new ArrayList<Future<Nodes>>(threads);
        boolean working = true;
        do {
            long skip = offset;
            futures.add(pool.submit(() -> this.loadNodes(skip, batchSize)));
            offset += (long)batchSize;
            if (futures.size() < threads) continue;
            for (Future future : futures) {
                Nodes result = (Nodes)this.get("Error during loading nodes offset: " + (lastOffset + (long)batchSize), future);
                lastOffset = result.offset;
                total += result.rows;
                working = result.idMap.size() > 0;
                if (!working) continue;
                int minNodeId = nodeToGraphIds.size();
                WeightMapping resultWeights = hasNodeWeights && result.nodeWeights.size() > 0 ? result.nodeWeights : null;
                WeightMapping resultProps = hasNodeProperty && result.nodeProps.size() > 0 ? result.nodeProps : null;
                result.idMap.nodeToGraphIds().forEach((graphId, algoId) -> {
                    int newId = algoId + minNodeId;
                    nodeToGraphIds.put(graphId, newId);
                    if (resultWeights != null) {
                        nodeWeights.set(newId, (Object)resultWeights.get(algoId));
                    }
                    if (resultProps != null) {
                        nodeProps.set(newId, (Object)resultProps.get(algoId));
                    }
                });
            }
            futures.clear();
        } while (working);
        long[] graphIds = new long[nodeToGraphIds.size()];
        for (LongIntCursor cursor : nodeToGraphIds) {
            graphIds[cursor.value] = cursor.key;
        }
        return new Nodes(0L, total, new IdMap(graphIds, nodeToGraphIds), nodeWeights, nodeProps);
    }

    private <T> T get(String message, Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted: " + message, e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(message, e);
        }
    }

    private boolean canBatchLoad(int batchSize, String statement) {
        return !(!this.setup.loadConcurrent() || batchSize <= 0 || !statement.contains("{limit}") && !statement.contains("$limit") || !statement.contains("{skip}") && !statement.contains("$skip"));
    }

    private Relationships loadRelationships(long offset, int batchSize, Nodes nodes) {
        final IdMap idMap = nodes.idMap;
        int nodeCount = idMap.size();
        int capacity = batchSize == -1 ? nodeCount : batchSize;
        final AdjacencyMatrix matrix = new AdjacencyMatrix(nodeCount);
        final boolean hasRelationshipWeights = !this.setup.loadDefaultRelationshipWeight();
        final WeightMapping relWeigths = this.newWeightMapping(hasRelationshipWeights, this.setup.relationDefaultWeight, capacity);
        class RelationshipRowVisitor
        implements Result.ResultVisitor<RuntimeException> {
            private long lastSourceId = -1L;
            private long lastTargetId = -1L;
            private int source = -1;
            private int target = -1;
            private long rows = 0L;

            RelationshipRowVisitor() {
            }

            public boolean visit(Result.ResultRow row) throws RuntimeException {
                ++this.rows;
                long sourceId = row.getNumber("source").longValue();
                if (sourceId != this.lastSourceId) {
                    this.source = idMap.get(sourceId);
                    this.lastSourceId = sourceId;
                }
                if (this.source == -1) {
                    return true;
                }
                long targetId = row.getNumber("target").longValue();
                if (targetId != this.lastTargetId) {
                    this.target = idMap.get(targetId);
                    this.lastTargetId = targetId;
                }
                if (this.target == -1) {
                    return true;
                }
                if (hasRelationshipWeights) {
                    long relId = RawValues.combineIntInt(this.source, this.target);
                    relWeigths.set(relId, row.get("weight"));
                }
                matrix.addOutgoing(this.source, this.target);
                return true;
            }
        }
        RelationshipRowVisitor visitor = new RelationshipRowVisitor();
        this.api.execute(this.setup.relationshipType, this.params(offset, batchSize)).accept((Result.ResultVisitor)visitor);
        return new Relationships(offset, visitor.rows, matrix, relWeigths);
    }

    private Nodes loadNodes(long offset, int batchSize) {
        int capacity = batchSize == -1 ? 1000000 : batchSize;
        final IdMap idMap = new IdMap(capacity);
        final boolean hasNodeWeights = !this.setup.loadDefaultNodeWeight();
        final WeightMapping nodeWeights = this.newWeightMapping(hasNodeWeights, this.setup.nodeDefaultWeight, capacity);
        final boolean hasNodeProperty = !this.setup.loadDefaultNodeProperty();
        final WeightMapping nodeProps = this.newWeightMapping(hasNodeProperty, this.setup.nodeDefaultPropertyValue, capacity);
        class NodeRowVisitor
        implements Result.ResultVisitor<RuntimeException> {
            private long rows;

            NodeRowVisitor() {
            }

            public boolean visit(Result.ResultRow row) throws RuntimeException {
                ++this.rows;
                long id = row.getNumber("id").longValue();
                idMap.add(id);
                if (hasNodeWeights) {
                    nodeWeights.set(id, row.get("weight"));
                }
                if (hasNodeProperty) {
                    nodeProps.set(id, row.get("value"));
                }
                return true;
            }
        }
        NodeRowVisitor visitor = new NodeRowVisitor();
        this.api.execute(this.setup.startLabel, this.params(offset, batchSize)).accept((Result.ResultVisitor)visitor);
        idMap.buildMappedIds();
        return new Nodes(offset, visitor.rows, idMap, nodeWeights, nodeProps);
    }

    private WeightMapping newWeightMapping(boolean needWeights, double defaultValue, int capacity) {
        return needWeights ? new WeightMap(capacity, defaultValue, -2) : new NullWeightMap(defaultValue);
    }

    private Map<String, Object> params(long offset, int batchSize) {
        return batchSize > 0 ? MapUtil.map((Object[])new Object[]{SKIP, offset, LIMIT, batchSize}) : MapUtil.map((Object[])new Object[]{SKIP, offset});
    }

    static class Relationships {
        private final long offset;
        private final long rows;
        private final AdjacencyMatrix matrix;
        private final WeightMapping relWeights;

        Relationships(long offset, long rows, AdjacencyMatrix matrix, WeightMapping relWeights) {
            this.offset = offset;
            this.rows = rows;
            this.matrix = matrix;
            this.relWeights = relWeights;
        }
    }

    static class Nodes {
        private final long offset;
        private final long rows;
        IdMap idMap;
        WeightMapping nodeWeights;
        WeightMapping nodeProps;

        Nodes(long offset, long rows, IdMap idMap, WeightMapping nodeWeights, WeightMapping nodeProps) {
            this.offset = offset;
            this.rows = rows;
            this.idMap = idMap;
            this.nodeWeights = nodeWeights;
            this.nodeProps = nodeProps;
        }
    }
}

