/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.heavyweight;

import java.util.Collection;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.NodeWeights;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.RelationshipWeights;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.api.WeightedRelationshipConsumer;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.heavyweight.AdjacencyMatrix;
import org.neo4j.graphdb.Direction;

public class HeavyGraph
implements Graph,
RelationshipWeights,
NodeWeights,
NodeProperties {
    private final IdMap nodeIdMap;
    private AdjacencyMatrix container;
    private WeightMapping relationshipWeights;
    private WeightMapping nodeWeights;
    private WeightMapping nodeProperties;

    HeavyGraph(IdMap nodeIdMap, AdjacencyMatrix container, WeightMapping relationshipWeights, WeightMapping nodeWeights, WeightMapping nodeProperties) {
        this.nodeIdMap = nodeIdMap;
        this.container = container;
        this.relationshipWeights = relationshipWeights;
        this.nodeWeights = nodeWeights;
        this.nodeProperties = nodeProperties;
    }

    @Override
    public long nodeCount() {
        return this.nodeIdMap.size();
    }

    @Override
    public void forEachNode(IntPredicate consumer) {
        this.nodeIdMap.forEach(consumer);
    }

    @Override
    public PrimitiveIntIterator nodeIterator() {
        return this.nodeIdMap.iterator();
    }

    @Override
    public Collection<PrimitiveIntIterable> batchIterables(int batchSize) {
        return this.nodeIdMap.batchIterables(batchSize);
    }

    @Override
    public int degree(int nodeId, Direction direction) {
        return this.container.degree(nodeId, direction);
    }

    @Override
    public void forEachRelationship(int nodeId, Direction direction, RelationshipConsumer consumer) {
        this.container.forEach(nodeId, direction, consumer);
    }

    @Override
    public void forEachRelationship(int nodeId, Direction direction, WeightedRelationshipConsumer consumer) {
        this.container.forEach(nodeId, direction, this.relationshipWeights, consumer);
    }

    @Override
    public int toMappedNodeId(long originalNodeId) {
        return this.nodeIdMap.get(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(int mappedNodeId) {
        return this.nodeIdMap.toOriginalNodeId(mappedNodeId);
    }

    @Override
    public boolean contains(long nodeId) {
        return this.nodeIdMap.contains(nodeId);
    }

    @Override
    public double weightOf(int sourceNodeId, int targetNodeId) {
        return this.relationshipWeights.get(sourceNodeId, targetNodeId);
    }

    @Override
    public double weightOf(int nodeId) {
        return this.nodeWeights.get(nodeId);
    }

    @Override
    public double valueOf(int nodeId, double defaultValue) {
        return this.nodeProperties.get(nodeId, defaultValue);
    }

    @Override
    public void release() {
        this.container = null;
        this.relationshipWeights = null;
        this.nodeWeights = null;
        this.nodeProperties = null;
    }
}

