/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.heavyweight;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.heavyweight.AdjacencyMatrix;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraph;
import org.neo4j.graphalgo.core.heavyweight.RelationshipImporter;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class HeavyGraphFactory
extends GraphFactory {
    public HeavyGraphFactory(GraphDatabaseAPI api, GraphSetup setup) {
        super(api, setup);
    }

    @Override
    public Graph build() {
        return this.build(this.setup.batchSize);
    }

    Graph build(int batchSize) {
        try {
            return this.importGraph(batchSize);
        }
        catch (EntityNotFoundException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    private Graph importGraph(int batchSize) throws EntityNotFoundException {
        IdMap idMap = this.loadIdMap();
        Supplier<WeightMapping> relWeights = () -> this.newWeightMap(this.dimensions.relWeightId(), this.setup.relationDefaultWeight);
        Supplier<WeightMapping> nodeWeights = () -> this.newWeightMap(this.dimensions.nodeWeightId(), this.setup.nodeDefaultWeight);
        Supplier<WeightMapping> nodeProps = () -> this.newWeightMap(this.dimensions.nodePropId(), this.setup.nodeDefaultPropertyValue);
        int concurrency = this.setup.concurrency();
        int nodeCount = this.dimensions.nodeCount();
        int actualBatchSize = ParallelUtil.adjustBatchSize(nodeCount, concurrency, batchSize);
        List<RelationshipImporter> tasks = ParallelUtil.readParallel(concurrency, actualBatchSize, idMap, (offset, nodeIds) -> new RelationshipImporter(this.api, this.setup, this.dimensions, this.progress, actualBatchSize, offset, idMap, nodeIds, relWeights, nodeWeights, nodeProps), this.threadPool);
        Graph graph = this.buildCompleteGraph(nodeCount, idMap, relWeights, nodeWeights, nodeProps, tasks);
        this.progressLogger.logDone();
        return graph;
    }

    private Graph buildCompleteGraph(int nodeCount, IdMap idMap, Supplier<WeightMapping> relWeightsSupplier, Supplier<WeightMapping> nodeWeightsSupplier, Supplier<WeightMapping> nodePropsSupplier, Collection<RelationshipImporter> tasks) {
        if (tasks.size() == 1) {
            RelationshipImporter importer = tasks.iterator().next();
            return importer.toGraph(idMap);
        }
        AdjacencyMatrix matrix = new AdjacencyMatrix(nodeCount);
        WeightMapping relWeights = relWeightsSupplier.get();
        WeightMapping nodeWeights = nodeWeightsSupplier.get();
        WeightMapping nodeProps = nodePropsSupplier.get();
        for (RelationshipImporter task : tasks) {
            task.writeInto(matrix, relWeights, nodeWeights, nodeProps);
            task.release();
        }
        return new HeavyGraph(idMap, matrix, relWeights, nodeWeights, nodeProps);
    }
}

