/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.heavyweight;

import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.GraphDimensions;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.WeightMap;
import org.neo4j.graphalgo.core.heavyweight.AdjacencyMatrix;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraph;
import org.neo4j.graphalgo.core.utils.ImportProgress;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphalgo.core.utils.StatementTask;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

final class RelationshipImporter
extends StatementTask<Void, EntityNotFoundException> {
    private IdMap idMap;
    private final PrimitiveIntIterable nodes;
    private WeightMapping relWeights;
    private WeightMapping nodeWeights;
    private WeightMapping nodeProps;
    private final ImportProgress progress;
    private final int[] relationId;
    private final boolean loadIncoming;
    private final boolean loadOutgoing;
    private AdjacencyMatrix matrix;
    private final int nodeOffset;
    private int currentNodeCount;
    private int sourceGraphId;

    RelationshipImporter(GraphDatabaseAPI api, GraphSetup setup, GraphDimensions dimensions, ImportProgress progress, int batchSize, int nodeOffset, IdMap idMap, PrimitiveIntIterable nodes, Supplier<WeightMapping> relWeights, Supplier<WeightMapping> nodeWeights, Supplier<WeightMapping> nodeProps) {
        super(api);
        int nodeSize = Math.min(batchSize, idMap.size() - nodeOffset);
        this.progress = progress;
        this.nodeOffset = nodeOffset;
        this.idMap = idMap;
        this.nodes = nodes;
        this.relWeights = relWeights.get();
        this.nodeWeights = nodeWeights.get();
        this.nodeProps = nodeProps.get();
        this.relationId = dimensions.relationId();
        this.loadIncoming = setup.loadIncoming;
        this.loadOutgoing = setup.loadOutgoing;
        this.matrix = new AdjacencyMatrix(nodeSize, this.loadIncoming, this.loadOutgoing);
        this.currentNodeCount = 0;
    }

    @Override
    public String threadName() {
        return String.format("[Heavy] RelationshipImport (%d..%d)", this.nodeOffset, this.nodeOffset + this.matrix.capacity());
    }

    @Override
    public Void apply(Statement statement) throws EntityNotFoundException {
        WeightMap weights;
        boolean hasWeights;
        ReadOperations readOp = statement.readOperations();
        boolean loadIncoming = this.loadIncoming;
        boolean loadOutgoing = this.loadOutgoing;
        RelationshipVisitor visitOutgoing = null;
        RelationshipVisitor visitIncoming = null;
        boolean bl = hasWeights = !(this.relWeights instanceof WeightMap);
        if (loadOutgoing) {
            if (!hasWeights) {
                weights = (WeightMap)this.relWeights;
                hasWeights = true;
                visitOutgoing = (relationshipId, typeId, startNodeId, endNodeId) -> this.visitOutgoingWithWeight(readOp, this.sourceGraphId, weights, relationshipId, endNodeId);
            } else {
                visitOutgoing = (relationshipId, typeId, startNodeId, endNodeId) -> this.visitOutgoing(endNodeId);
            }
        }
        if (loadIncoming) {
            if (!hasWeights) {
                weights = (WeightMap)this.relWeights;
                visitIncoming = (relationshipId, typeId, startNodeId, endNodeId) -> this.visitIncomingWithWeight(readOp, this.sourceGraphId, weights, relationshipId, startNodeId);
            } else {
                visitIncoming = (relationshipId, typeId, startNodeId, endNodeId) -> this.visitIncoming(startNodeId);
            }
        }
        PrimitiveIntIterator iterator = this.nodes.iterator();
        int nodeOffset = this.nodeOffset;
        int nodeCount = 0;
        while (iterator.hasNext()) {
            int nodeId = iterator.next();
            long sourceNodeId = this.idMap.toOriginalNodeId(nodeId);
            this.sourceGraphId = nodeId - nodeOffset;
            ++nodeCount;
            this.readNode(readOp, sourceNodeId, this.sourceGraphId, this.matrix, loadIncoming, loadOutgoing, (RelationshipVisitor<EntityNotFoundException>)visitOutgoing, (RelationshipVisitor<EntityNotFoundException>)visitIncoming, this.nodeWeights, this.nodeProps, this.relationId);
            this.progress.relProgress();
        }
        this.currentNodeCount = nodeCount;
        return null;
    }

    private void readNode(ReadOperations readOp, long sourceNodeId, int localNodeId, AdjacencyMatrix matrix, boolean loadIncoming, boolean loadOutgoing, RelationshipVisitor<EntityNotFoundException> visitOutgoing, RelationshipVisitor<EntityNotFoundException> visitIncoming, WeightMapping nodeWeights, WeightMapping nodeProps, int[] relationType) throws EntityNotFoundException {
        WeightMap weights;
        if (loadOutgoing) {
            this.readOutgoing(readOp, visitOutgoing, sourceNodeId, localNodeId, matrix, relationType);
        }
        if (loadIncoming) {
            this.readIncoming(readOp, visitIncoming, sourceNodeId, localNodeId, matrix, relationType);
        }
        if (nodeWeights instanceof WeightMap) {
            weights = (WeightMap)nodeWeights;
            this.readNodeWeight(readOp, sourceNodeId, localNodeId, weights, weights.propertyId());
        }
        if (nodeProps instanceof WeightMap) {
            weights = (WeightMap)nodeProps;
            this.readNodeWeight(readOp, sourceNodeId, localNodeId, weights, weights.propertyId());
        }
    }

    private void readOutgoing(ReadOperations readOp, RelationshipVisitor<EntityNotFoundException> visit, long sourceNodeId, int localNodeId, AdjacencyMatrix matrix, int[] relationType) throws EntityNotFoundException {
        RelationshipIterator rels;
        int outDegree;
        if (relationType == null) {
            outDegree = readOp.nodeGetDegree(sourceNodeId, Direction.OUTGOING);
            rels = readOp.nodeGetRelationships(sourceNodeId, Direction.OUTGOING);
        } else {
            outDegree = readOp.nodeGetDegree(sourceNodeId, Direction.OUTGOING, relationType[0]);
            rels = readOp.nodeGetRelationships(sourceNodeId, Direction.OUTGOING, relationType);
        }
        matrix.armOut(localNodeId, outDegree);
        while (rels.hasNext()) {
            long relId = rels.next();
            rels.relationshipVisit(relId, visit);
        }
    }

    private void readIncoming(ReadOperations readOp, RelationshipVisitor<EntityNotFoundException> visit, long sourceNodeId, int localNodeId, AdjacencyMatrix matrix, int[] relationType) throws EntityNotFoundException {
        RelationshipIterator rels;
        int outDegree;
        if (relationType == null) {
            outDegree = readOp.nodeGetDegree(sourceNodeId, Direction.INCOMING);
            rels = readOp.nodeGetRelationships(sourceNodeId, Direction.INCOMING);
        } else {
            outDegree = readOp.nodeGetDegree(sourceNodeId, Direction.INCOMING, relationType[0]);
            rels = readOp.nodeGetRelationships(sourceNodeId, Direction.INCOMING, relationType);
        }
        matrix.armIn(localNodeId, outDegree);
        while (rels.hasNext()) {
            long relId = rels.next();
            rels.relationshipVisit(relId, visit);
        }
    }

    private void readNodeWeight(ReadOperations readOp, long sourceNodeId, int sourceGraphId, WeightMap weights, int propertyId) {
        try {
            Object value = readOp.nodeGetProperty(sourceNodeId, propertyId);
            if (value != null) {
                weights.set(sourceGraphId, value);
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private int visitOutgoing(long endNodeId) throws EntityNotFoundException {
        int targetGraphId = this.idMap.get(endNodeId);
        if (targetGraphId != -1) {
            this.matrix.addOutgoing(this.sourceGraphId, targetGraphId);
        }
        return targetGraphId;
    }

    private int visitOutgoingWithWeight(ReadOperations readOp, int sourceGraphId, WeightMap weights, long relationshipId, long endNodeId) throws EntityNotFoundException {
        int targetGraphId = this.visitOutgoing(endNodeId);
        if (targetGraphId != -1) {
            this.visitWeight(readOp, sourceGraphId, targetGraphId, weights, relationshipId);
        }
        return targetGraphId;
    }

    private int visitIncoming(long startNodeId) throws EntityNotFoundException {
        int startGraphId = this.idMap.get(startNodeId);
        if (startGraphId != -1) {
            this.matrix.addIncoming(startGraphId, this.sourceGraphId);
        }
        return startGraphId;
    }

    private int visitIncomingWithWeight(ReadOperations readOp, int sourceGraphId, WeightMap weights, long relationshipId, long startNodeId) throws EntityNotFoundException {
        int targetGraphId = this.visitIncoming(startNodeId);
        if (targetGraphId != -1) {
            this.visitWeight(readOp, sourceGraphId, targetGraphId, weights, relationshipId);
        }
        return targetGraphId;
    }

    private void visitWeight(ReadOperations readOp, int sourceGraphId, int targetGraphId, WeightMap weights, long relationshipId) {
        try {
            Object value = readOp.relationshipGetProperty(relationshipId, weights.propertyId());
            if (value != null) {
                long relId = RawValues.combineIntInt(sourceGraphId, targetGraphId);
                weights.set(relId, value);
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    Graph toGraph(IdMap idMap) {
        return new HeavyGraph(idMap, this.matrix, this.relWeights, this.nodeWeights, this.nodeProps);
    }

    void writeInto(AdjacencyMatrix matrix, WeightMapping relWeights, WeightMapping nodeWeights, WeightMapping nodeProps) {
        matrix.addMatrix(this.matrix, this.nodeOffset, this.currentNodeCount);
        this.combineMaps(relWeights, this.relWeights, this.nodeOffset);
        this.combineMaps(nodeWeights, this.nodeWeights, this.nodeOffset);
        this.combineMaps(nodeProps, this.nodeProps, this.nodeOffset);
    }

    void release() {
        this.idMap = null;
        this.matrix = null;
        this.relWeights = null;
        this.nodeWeights = null;
        this.nodeProps = null;
    }

    private void combineMaps(WeightMapping global, WeightMapping local, int offset) {
        if (global instanceof WeightMap && local instanceof WeightMap) {
            WeightMap localWeights = (WeightMap)local;
            LongDoubleMap localMap = localWeights.weights();
            WeightMap globalWeights = (WeightMap)global;
            LongDoubleMap globalMap = globalWeights.weights();
            for (LongDoubleCursor cursor : localMap) {
                globalMap.put(cursor.key + (long)offset, cursor.value);
            }
        }
    }
}

