/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.huge;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.ArrayUtil;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.api.HugeWeightMapping;
import org.neo4j.graphalgo.core.GraphDimensions;
import org.neo4j.graphalgo.core.HugeWeightMap;
import org.neo4j.graphalgo.core.huge.HugeGraphImpl;
import org.neo4j.graphalgo.core.huge.HugeIdMap;
import org.neo4j.graphalgo.core.utils.ImportProgress;
import org.neo4j.graphalgo.core.utils.ParallelUtil;
import org.neo4j.graphalgo.core.utils.StatementTask;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.ByteArray;
import org.neo4j.graphalgo.core.utils.paged.LongArray;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class HugeGraphFactory
extends GraphFactory {
    public HugeGraphFactory(GraphDatabaseAPI api, GraphSetup setup) {
        super(api, setup);
    }

    @Override
    public HugeGraph build() {
        try {
            return this.importGraph();
        }
        catch (EntityNotFoundException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    private HugeGraph importGraph() throws EntityNotFoundException {
        int concurrency = this.setup.concurrency();
        int batchSize = this.setup.batchSize;
        AllocationTracker tracker = this.setup.tracker;
        HugeWeightMapping weights = this.hugeWeightMapping(tracker, this.dimensions.weightId(), this.setup.relationDefaultWeight);
        HugeIdMap mapping = this.loadHugeIdMap(tracker);
        HugeGraph graph = this.loadRelationships(this.dimensions, mapping, weights, concurrency, batchSize, tracker, this.progress);
        this.progressLogger.logDone(tracker);
        return graph;
    }

    private HugeGraph loadRelationships(GraphDimensions dimensions, HugeIdMap mapping, HugeWeightMapping weights, int concurrency, int batchSize, AllocationTracker tracker, ImportProgress progress) {
        long nodeCount = dimensions.hugeNodeCount();
        int[] relationId = dimensions.relationId();
        int weightId = dimensions.weightId();
        boolean loadsAnything = false;
        LongArray inOffsets = null;
        LongArray outOffsets = null;
        ByteArray inAdjacency = null;
        ByteArray outAdjacency = null;
        if (this.setup.loadIncoming) {
            inOffsets = LongArray.newArray(nodeCount, tracker);
            inAdjacency = ByteArray.newArray(0L, tracker);
            inAdjacency.skipAllocationRegion(1L);
            loadsAnything = true;
        }
        if (this.setup.loadOutgoing) {
            outOffsets = LongArray.newArray(nodeCount, tracker);
            outAdjacency = ByteArray.newArray(nodeCount, tracker);
            outAdjacency.skipAllocationRegion(1L);
            loadsAnything = true;
        }
        if (loadsAnything) {
            LongArray finalInOffsets = inOffsets;
            LongArray finalOutOffsets = outOffsets;
            ByteArray finalInAdjacency = inAdjacency;
            ByteArray finalOutAdjacency = outAdjacency;
            AtomicInteger batchIndex = new AtomicInteger();
            ParallelUtil.readParallel(concurrency, batchSize, mapping, (offset, nodeIds) -> new BatchImportTask(this.api, batchIndex.getAndIncrement(), nodeIds, progress, mapping, finalInOffsets, finalOutOffsets, finalInAdjacency, finalOutAdjacency, relationId, weightId, weights), this.threadPool);
        }
        return new HugeGraphImpl(tracker, mapping, weights, inAdjacency, outAdjacency, inOffsets, outOffsets);
    }

    private static final class RelationshipImporterWithWeights
    extends DeltaEncodingVisitor {
        private final int weightId;
        private final HugeWeightMap weights;
        private final ReadOperations readOp;

        private RelationshipImporterWithWeights(HugeIdMap idMap, Direction direction, ReadOperations readOp, int weightId, HugeWeightMapping weights) {
            super(idMap, direction);
            this.readOp = readOp;
            if (!(weights instanceof HugeWeightMap) || weightId < 0) {
                throw new IllegalArgumentException("expected weights to be defined");
            }
            this.weightId = weightId;
            this.weights = (HugeWeightMap)weights;
        }

        @Override
        long maybeVisit(long relationshipId, long endNodeId) throws EntityNotFoundException {
            long targetGraphId = super.maybeVisit(relationshipId, endNodeId);
            if (targetGraphId >= 0L) {
                Object value = this.readOp.relationshipGetProperty(relationshipId, this.weightId);
                if (this.direction == Direction.OUTGOING) {
                    this.weights.put(this.sourceGraphId, targetGraphId, value);
                } else {
                    this.weights.put(targetGraphId, this.sourceGraphId, value);
                }
            }
            return targetGraphId;
        }
    }

    private static class DeltaEncodingVisitor
    implements RelationshipVisitor<EntityNotFoundException> {
        private static final int[] encodingSizeCache = new int[66];
        private final HugeIdMap idMap;
        final Direction direction;
        long sourceGraphId;
        private long prevTarget;
        private boolean isSorted;
        private long[] targets;
        private int length;

        private DeltaEncodingVisitor(HugeIdMap idMap, Direction direction) {
            this.idMap = idMap;
            this.direction = direction;
            this.targets = new long[0];
        }

        final void reset(int degree, long sourceGraphId) {
            this.length = 0;
            this.sourceGraphId = sourceGraphId;
            this.prevTarget = -1L;
            this.isSorted = true;
            if (this.targets.length < degree) {
                this.targets = new long[ArrayUtil.oversize((int)degree, (int)8)];
            }
        }

        public final void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
            this.maybeVisit(relationshipId, this.direction == Direction.OUTGOING ? endNodeId : startNodeId);
        }

        long maybeVisit(long relationshipId, long endNodeId) throws EntityNotFoundException {
            long targetId = this.idMap.toHugeMappedNodeId(endNodeId);
            if (targetId == -1L) {
                return -1L;
            }
            if (this.isSorted && targetId < this.prevTarget) {
                this.isSorted = false;
            }
            long l = targetId;
            this.targets[this.length++] = l;
            this.prevTarget = l;
            return l;
        }

        final long applyDelta() {
            int length = this.length;
            long[] targets = this.targets;
            if (!this.isSorted) {
                Arrays.sort(targets, 0, length);
            }
            long delta = 0L;
            long requiredBytes = 4L;
            int i = 0;
            while (i < length) {
                long nextDelta = targets[i];
                int n = i++;
                long l = targets[n] - delta;
                targets[n] = l;
                long value = l;
                delta = nextDelta;
                int bits = Long.numberOfTrailingZeros(Long.highestOneBit(value)) + 1;
                requiredBytes += (long)encodingSizeCache[bits];
            }
            return requiredBytes;
        }

        static {
            for (int i = 0; i < 65; ++i) {
                DeltaEncodingVisitor.encodingSizeCache[i] = (int)Math.ceil((double)i / 7.0);
            }
            DeltaEncodingVisitor.encodingSizeCache[65] = 1;
        }
    }

    private static final class BatchImportTask
    extends StatementTask<Void, EntityNotFoundException> {
        private final int batchIndex;
        private final ImportProgress progress;
        private final PrimitiveLongIterable nodes;
        private final HugeIdMap idMap;
        private final LongArray inOffsets;
        private final LongArray outOffsets;
        private final ByteArray.LocalAllocator inAllocator;
        private final ByteArray.LocalAllocator outAllocator;
        private final int[] relationId;
        private final int weightId;
        private final HugeWeightMapping weights;
        private DeltaEncodingVisitor inImporter;
        private DeltaEncodingVisitor outImporter;

        BatchImportTask(GraphDatabaseAPI api, int batchIndex, PrimitiveLongIterable nodes, ImportProgress progress, HugeIdMap idMap, LongArray inOffsets, LongArray outOffsets, ByteArray inAdjacency, ByteArray outAdjacency, int[] relationId, int weightId, HugeWeightMapping weights) {
            super(api);
            this.batchIndex = batchIndex;
            this.progress = progress;
            this.nodes = nodes;
            this.idMap = idMap;
            this.inOffsets = inOffsets;
            this.outOffsets = outOffsets;
            this.inAllocator = inAdjacency != null ? inAdjacency.newAllocator() : null;
            this.outAllocator = outAdjacency != null ? outAdjacency.newAllocator() : null;
            this.relationId = relationId;
            this.weightId = weightId;
            this.weights = weights;
        }

        @Override
        public String threadName() {
            return "HugeRelationshipImport-" + this.batchIndex;
        }

        @Override
        public Void apply(Statement statement) throws EntityNotFoundException {
            boolean loadOutgoing;
            ReadOperations readOp = statement.readOperations();
            PrimitiveLongIterator iterator = this.nodes.iterator();
            boolean loadIncoming = this.inAllocator != null;
            boolean bl = loadOutgoing = this.outAllocator != null;
            if (loadIncoming) {
                this.inImporter = this.newImporter(readOp, this.idMap, Direction.INCOMING);
            }
            if (loadOutgoing) {
                this.outImporter = this.newImporter(readOp, this.idMap, Direction.OUTGOING);
            }
            while (iterator.hasNext()) {
                long nodeId = iterator.next();
                long neoId = this.idMap.toOriginalNodeId(nodeId);
                this.readNodeBatch(nodeId, neoId, readOp, loadIncoming, loadOutgoing);
                this.progress.relProgress();
            }
            return null;
        }

        DeltaEncodingVisitor newImporter(ReadOperations readOp, HugeIdMap idMap, Direction direction) {
            if (this.weightId >= 0) {
                return new RelationshipImporterWithWeights(idMap, direction, readOp, this.weightId, this.weights);
            }
            return new DeltaEncodingVisitor(idMap, direction);
        }

        private void readNodeBatch(long sourceGraphId, long sourceNodeId, ReadOperations readOp, boolean loadIncoming, boolean loadOutgoing) throws EntityNotFoundException {
            if (loadOutgoing) {
                this.readRelationshipsBatch(sourceGraphId, sourceNodeId, readOp, Direction.OUTGOING, this.outOffsets, this.outAllocator, this.outImporter);
            }
            if (loadIncoming) {
                this.readRelationshipsBatch(sourceGraphId, sourceNodeId, readOp, Direction.INCOMING, this.inOffsets, this.inAllocator, this.inImporter);
            }
        }

        private void readRelationshipsBatch(long sourceGraphId, long sourceNodeId, ReadOperations readOp, Direction direction, LongArray offsets, ByteArray.LocalAllocator allocator, DeltaEncodingVisitor delta) throws EntityNotFoundException {
            int degree;
            int n = degree = this.relationId == null ? readOp.nodeGetDegree(sourceNodeId, direction) : readOp.nodeGetDegree(sourceNodeId, direction, this.relationId[0]);
            if (degree <= 0) {
                return;
            }
            RelationshipIterator rs = this.relationships(sourceNodeId, readOp, direction);
            delta.reset(degree, sourceGraphId);
            while (rs.hasNext()) {
                rs.relationshipVisit(rs.next(), (RelationshipVisitor)delta);
            }
            degree = delta.length;
            if (degree == 0) {
                return;
            }
            long requiredSize = delta.applyDelta();
            long adjacencyIdx = allocator.allocate(requiredSize);
            offsets.set(sourceGraphId, adjacencyIdx);
            ByteArray.BulkAdder bulkAdder = allocator.adder;
            bulkAdder.addUnsignedInt(degree);
            long[] targets = delta.targets;
            for (int i = 0; i < degree; ++i) {
                bulkAdder.addVLong(targets[i]);
            }
        }

        private RelationshipIterator relationships(long sourceNodeId, ReadOperations readOp, Direction direction) throws EntityNotFoundException {
            return this.relationId == null ? readOp.nodeGetRelationships(sourceNodeId, direction) : readOp.nodeGetRelationships(sourceNodeId, direction, this.relationId);
        }
    }
}

