/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.huge;

import java.util.Collection;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.api.HugeRelationshipConsumer;
import org.neo4j.graphalgo.api.HugeWeightMapping;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.WeightedRelationshipConsumer;
import org.neo4j.graphalgo.core.huge.HugeIdMap;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.ByteArray;
import org.neo4j.graphalgo.core.utils.paged.LongArray;
import org.neo4j.graphdb.Direction;

public class HugeGraphImpl
implements HugeGraph {
    private final HugeIdMap idMapping;
    private final AllocationTracker tracker;
    private HugeWeightMapping weights;
    private ByteArray inAdjacency;
    private ByteArray outAdjacency;
    private LongArray inOffsets;
    private LongArray outOffsets;
    private ByteArray.DeltaCursor empty;
    private ByteArray.DeltaCursor inCache;
    private ByteArray.DeltaCursor outCache;

    HugeGraphImpl(AllocationTracker tracker, HugeIdMap idMapping, HugeWeightMapping weights, ByteArray inAdjacency, ByteArray outAdjacency, LongArray inOffsets, LongArray outOffsets) {
        this.idMapping = idMapping;
        this.tracker = tracker;
        this.weights = weights;
        this.inAdjacency = inAdjacency;
        this.outAdjacency = outAdjacency;
        this.inOffsets = inOffsets;
        this.outOffsets = outOffsets;
        this.inCache = this.newCursor(this.inAdjacency);
        this.outCache = this.newCursor(this.outAdjacency);
        this.empty = this.inCache == null ? this.newCursor(this.outAdjacency) : this.newCursor(this.inAdjacency);
    }

    @Override
    public long nodeCount() {
        return this.idMapping.nodeCount();
    }

    @Override
    public Collection<PrimitiveLongIterable> hugeBatchIterables(int batchSize) {
        return this.idMapping.hugeBatchIterables(batchSize);
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        this.idMapping.forEachNode(consumer);
    }

    @Override
    public PrimitiveLongIterator hugeNodeIterator() {
        return this.idMapping.hugeNodeIterator();
    }

    @Override
    public double weightOf(long sourceNodeId, long targetNodeId) {
        return this.weights.weight(sourceNodeId, targetNodeId);
    }

    @Override
    public double weightOf(long sourceNodeId, long targetNodeId, double defaultWeight) {
        return this.weights.weight(sourceNodeId, targetNodeId, defaultWeight);
    }

    @Override
    public void forEachRelationship(long vertexId, Direction direction, HugeRelationshipConsumer consumer) {
        switch (direction) {
            case INCOMING: {
                this.forEachIncoming(vertexId, consumer);
                return;
            }
            case OUTGOING: {
                this.forEachOutgoing(vertexId, consumer);
                return;
            }
            case BOTH: {
                this.forEachIncoming(vertexId, consumer);
                this.forEachOutgoing(vertexId, consumer);
                return;
            }
        }
        throw new IllegalArgumentException(direction + "");
    }

    @Override
    public void forEachRelationship(int nodeId, Direction direction, RelationshipConsumer consumer) {
        switch (direction) {
            case INCOMING: {
                this.forEachIncoming(nodeId, consumer);
                return;
            }
            case OUTGOING: {
                this.forEachOutgoing(nodeId, consumer);
                return;
            }
            case BOTH: {
                this.forEachIncoming(nodeId, consumer);
                this.forEachOutgoing(nodeId, consumer);
                return;
            }
        }
        throw new IllegalArgumentException(direction + "");
    }

    @Override
    public void forEachRelationship(int nodeId, Direction direction, WeightedRelationshipConsumer consumer) {
        RelationshipConsumer nonWeighted = (s, t, relId) -> {
            double weight = direction == Direction.OUTGOING ? this.weightOf(s, t) : this.weightOf(t, s);
            return consumer.accept(s, t, RawValues.combineIntInt(direction, s, t), weight);
        };
        this.forEachRelationship(nodeId, direction, nonWeighted);
    }

    @Override
    public int degree(long node, Direction direction) {
        switch (direction) {
            case INCOMING: {
                return this.degree(node, this.inOffsets, this.inAdjacency);
            }
            case OUTGOING: {
                return this.degree(node, this.outOffsets, this.outAdjacency);
            }
            case BOTH: {
                return this.degree(node, this.inOffsets, this.inAdjacency) + this.degree(node, this.outOffsets, this.outAdjacency);
            }
        }
        throw new IllegalArgumentException(direction + "");
    }

    @Override
    public long toHugeMappedNodeId(long nodeId) {
        return this.idMapping.toHugeMappedNodeId(nodeId);
    }

    @Override
    public long toOriginalNodeId(long vertexId) {
        return this.idMapping.toOriginalNodeId(vertexId);
    }

    @Override
    public boolean contains(long nodeId) {
        return this.idMapping.contains(nodeId);
    }

    @Override
    public void forEachIncoming(long node, HugeRelationshipConsumer consumer) {
        ByteArray.DeltaCursor cursor = this.cursor(node, this.inCache, this.inOffsets, this.inAdjacency);
        this.consumeNodes(node, cursor, consumer);
    }

    @Override
    public void forEachIncoming(int nodeId, RelationshipConsumer consumer) {
        long node = nodeId;
        ByteArray.DeltaCursor cursor = this.cursor(node, this.inAdjacency.newCursor(), this.inOffsets, this.inAdjacency);
        this.consumeNodes(node, cursor, (s, t) -> consumer.accept((int)s, (int)t, RawValues.combineIntInt((int)t, (int)s)));
    }

    @Override
    public void forEachOutgoing(long node, HugeRelationshipConsumer consumer) {
        ByteArray.DeltaCursor cursor = this.cursor(node, this.outCache, this.outOffsets, this.outAdjacency);
        this.consumeNodes(node, cursor, consumer);
    }

    @Override
    public void forEachOutgoing(int nodeId, RelationshipConsumer consumer) {
        long node = nodeId;
        ByteArray.DeltaCursor cursor = this.cursor(node, this.outAdjacency.newCursor(), this.outOffsets, this.outAdjacency);
        this.consumeNodes(node, cursor, (s, t) -> consumer.accept((int)s, (int)t, RawValues.combineIntInt((int)s, (int)t)));
    }

    @Override
    public HugeGraph concurrentCopy() {
        return new HugeGraphImpl(this.tracker, this.idMapping, this.weights, this.inAdjacency, this.outAdjacency, this.inOffsets, this.outOffsets);
    }

    private ByteArray.DeltaCursor newCursor(ByteArray adjacency) {
        return adjacency != null ? adjacency.newCursor() : null;
    }

    private int degree(long node, LongArray offsets, ByteArray array) {
        long offset = offsets.get(node);
        if (offset == 0L) {
            return 0;
        }
        return array.getInt(offset);
    }

    private ByteArray.DeltaCursor cursor(long node, ByteArray.DeltaCursor reuse, LongArray offsets, ByteArray array) {
        long offset = offsets.get(node);
        if (offset == 0L) {
            return this.empty;
        }
        return array.deltaCursor(reuse, offset);
    }

    private void consumeNodes(long startNode, ByteArray.DeltaCursor cursor, HugeRelationshipConsumer consumer) {
        long next;
        while ((next = cursor.getVLong()) != -1L && consumer.accept(startNode, next)) {
        }
    }

    @Override
    public void release() {
        if (this.inAdjacency != null) {
            this.tracker.remove(this.inAdjacency.release());
            this.tracker.remove(this.inOffsets.release());
            this.inAdjacency = null;
            this.inOffsets = null;
        }
        if (this.outAdjacency != null) {
            this.tracker.remove(this.outAdjacency.release());
            this.tracker.remove(this.outOffsets.release());
            this.outAdjacency = null;
            this.outOffsets = null;
        }
        this.tracker.remove(this.weights.release());
        this.empty = null;
        this.inCache = null;
        this.outCache = null;
        this.weights = null;
    }
}

