/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.huge;

import java.util.Collection;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.HugeBatchNodeIterable;
import org.neo4j.graphalgo.api.HugeIdMapping;
import org.neo4j.graphalgo.api.HugeNodeIterator;
import org.neo4j.graphalgo.core.utils.LazyBatchCollection;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.LongArray;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;
import org.neo4j.graphalgo.core.utils.paged.SparseLongArray;

public final class HugeIdMap
implements HugeIdMapping,
HugeNodeIterator,
HugeBatchNodeIterable {
    static final long NOT_FOUND = -1L;
    static final int PAGE_SIZE = PageUtil.pageSizeFor(8);
    private long nextGraphId;
    private LongArray graphIds;
    private SparseLongArray nodeToGraphIds;

    HugeIdMap(long capacity, long fullCapacity, AllocationTracker tracker) {
        this.graphIds = LongArray.newArray(capacity, tracker);
        this.nodeToGraphIds = SparseLongArray.newArray(fullCapacity, tracker);
    }

    HugeIdMap(long capacity, LongArray denseGraphMap, SparseLongArray sparseOriginalMap) {
        this.nextGraphId = capacity;
        this.graphIds = denseGraphMap;
        this.nodeToGraphIds = sparseOriginalMap;
    }

    void add(long longValue) {
        long internalId = this.nextGraphId++;
        this.nodeToGraphIds.set(longValue, internalId);
        this.graphIds.set(internalId, longValue);
    }

    @Override
    public long toHugeMappedNodeId(long nodeId) {
        return this.nodeToGraphIds.get(nodeId);
    }

    @Override
    public long toOriginalNodeId(long nodeId) {
        return this.graphIds.get(nodeId);
    }

    @Override
    public boolean contains(long nodeId) {
        return this.nodeToGraphIds.contains(nodeId);
    }

    @Override
    public long nodeCount() {
        return this.nextGraphId;
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        long count = this.nodeCount();
        for (long i = 0L; i < count; ++i) {
            if (consumer.test(i)) continue;
            return;
        }
    }

    @Override
    public PrimitiveLongIterator hugeNodeIterator() {
        return new IdIterator(this.nodeCount());
    }

    @Override
    public Collection<PrimitiveLongIterable> hugeBatchIterables(int batchSize) {
        return LazyBatchCollection.of(this.nodeCount(), batchSize, (x$0, x$1) -> new IdIterable(x$0, x$1));
    }

    private static final class IdIterator
    implements PrimitiveLongIterator {
        private long current;
        private long limit;

        private IdIterator(long length) {
            this.current = 0L;
            this.limit = length;
        }

        private IdIterator(long start, long length) {
            this.current = start;
            this.limit = start + length;
        }

        public boolean hasNext() {
            return this.current < this.limit;
        }

        public long next() {
            return this.current++;
        }
    }

    private static final class IdIterable
    implements PrimitiveLongIterable {
        private final long start;
        private final long length;

        private IdIterable(long start, long length) {
            this.start = start;
            this.length = length;
        }

        public PrimitiveLongIterator iterator() {
            return new IdIterator(this.start, this.length);
        }
    }
}

