/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.lightweight;

import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.lightweight.LightGraph;
import org.neo4j.graphalgo.core.lightweight.RelationshipImport;
import org.neo4j.graphalgo.core.lightweight.RelationshipImporter;
import org.neo4j.graphalgo.core.utils.StatementTask;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.IntArray;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

final class GraphImporter
extends StatementTask<LightGraph, EntityNotFoundException> {
    private final GraphSetup setup;
    private final IdMap mapping;
    private final WeightMapping weights;
    private final int nodeCount;
    private final int[] relationId;

    GraphImporter(GraphDatabaseAPI api, GraphSetup setup, IdMap mapping, WeightMapping weights, int nodeCount, int[] relationId) {
        super(api);
        this.setup = setup;
        this.mapping = mapping;
        this.weights = weights;
        this.nodeCount = nodeCount;
        this.relationId = relationId;
    }

    @Override
    public LightGraph apply(Statement statement) throws EntityNotFoundException {
        long[] inOffsets = null;
        long[] outOffsets = null;
        IntArray inAdjacency = null;
        IntArray outAdjacency = null;
        boolean loadIncoming = this.setup.loadIncoming;
        boolean loadOutgoing = this.setup.loadOutgoing;
        if (loadIncoming || loadOutgoing) {
            ReadOperations readOp = statement.readOperations();
            int nodeCount = this.nodeCount;
            RelationshipImporter inImporter = null;
            RelationshipImporter outImporter = null;
            if (loadIncoming) {
                inOffsets = new long[nodeCount + 1];
                inAdjacency = IntArray.newArray(nodeCount, AllocationTracker.EMPTY);
                inImporter = RelationshipImporter.of(readOp, this.mapping, inOffsets, this.relationId, Direction.INCOMING, inAdjacency.newBulkAdder(), this.weights);
            }
            if (loadOutgoing) {
                outOffsets = new long[nodeCount + 1];
                outOffsets[nodeCount] = nodeCount;
                outAdjacency = IntArray.newArray(nodeCount, AllocationTracker.EMPTY);
                outImporter = RelationshipImporter.of(readOp, this.mapping, outOffsets, this.relationId, Direction.OUTGOING, outAdjacency.newBulkAdder(), this.weights);
            }
            RelationshipImport importer = RelationshipImport.combine(inImporter, outImporter);
            long[] ids = this.mapping.mappedIds();
            int length = this.mapping.size();
            for (int i = 0; i < length; ++i) {
                importer.importRelationships(i, ids[i]);
            }
            if (loadIncoming) {
                inOffsets[nodeCount] = inImporter.adjacencyIdx();
            }
            if (loadOutgoing) {
                outOffsets[nodeCount] = outImporter.adjacencyIdx();
            }
        }
        return new LightGraph(this.mapping, this.weights, inAdjacency, outAdjacency, inOffsets, outOffsets);
    }
}

