/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.lightweight;

import java.util.Collection;
import java.util.function.IntPredicate;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.api.WeightedRelationshipConsumer;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.utils.IdCombiner;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphalgo.core.utils.paged.IntArray;
import org.neo4j.graphdb.Direction;

public class LightGraph
implements Graph {
    private final IdMap idMapping;
    private WeightMapping weightMapping;
    private IntArray inAdjacency;
    private IntArray outAdjacency;
    private long[] inOffsets;
    private long[] outOffsets;

    LightGraph(IdMap idMapping, WeightMapping weightMapping, IntArray inAdjacency, IntArray outAdjacency, long[] inOffsets, long[] outOffsets) {
        this.idMapping = idMapping;
        this.weightMapping = weightMapping;
        this.inAdjacency = inAdjacency;
        this.outAdjacency = outAdjacency;
        this.inOffsets = inOffsets;
        this.outOffsets = outOffsets;
    }

    @Override
    public long nodeCount() {
        return this.idMapping.size();
    }

    @Override
    public PrimitiveIntIterator nodeIterator() {
        return this.idMapping.iterator();
    }

    @Override
    public Collection<PrimitiveIntIterable> batchIterables(int batchSize) {
        return this.idMapping.batchIterables(batchSize);
    }

    @Override
    public void forEachNode(IntPredicate consumer) {
        this.idMapping.forEach(consumer);
    }

    @Override
    public void forEachRelationship(int vertexId, Direction direction, RelationshipConsumer consumer) {
        switch (direction) {
            case INCOMING: {
                this.forEachIncoming(vertexId, consumer);
                return;
            }
            case OUTGOING: {
                this.forEachOutgoing(vertexId, consumer);
                return;
            }
            case BOTH: {
                this.forEachIncoming(vertexId, consumer);
                this.forEachOutgoing(vertexId, consumer);
                return;
            }
        }
        throw new IllegalArgumentException(direction + "");
    }

    @Override
    public void forEachRelationship(int vertexId, Direction direction, WeightedRelationshipConsumer consumer) {
        switch (direction) {
            case INCOMING: {
                this.forEachIncoming(vertexId, consumer);
                return;
            }
            case OUTGOING: {
                this.forEachOutgoing(vertexId, consumer);
                return;
            }
            case BOTH: {
                this.forEachIncoming(vertexId, consumer);
                this.forEachOutgoing(vertexId, consumer);
                return;
            }
        }
        throw new IllegalArgumentException(direction + "");
    }

    @Override
    public int degree(int node, Direction direction) {
        switch (direction) {
            case INCOMING: {
                return (int)(this.inOffsets[node + 1] - this.inOffsets[node]);
            }
            case OUTGOING: {
                return (int)(this.outOffsets[node + 1] - this.outOffsets[node]);
            }
            case BOTH: {
                return (int)(this.inOffsets[node + 1] - this.inOffsets[node] + this.outOffsets[node + 1] - this.outOffsets[node]);
            }
        }
        throw new IllegalArgumentException(direction + "");
    }

    @Override
    public int toMappedNodeId(long nodeId) {
        return this.idMapping.get(nodeId);
    }

    @Override
    public long toOriginalNodeId(int vertexId) {
        return this.idMapping.toOriginalNodeId(vertexId);
    }

    @Override
    public boolean contains(long nodeId) {
        return this.idMapping.contains(nodeId);
    }

    @Override
    public void forEachIncoming(int node, RelationshipConsumer consumer) {
        IntArray.Cursor cursor = this.cursor(node, this.inOffsets, this.inAdjacency);
        this.consumeNodes(node, cursor, RawValues.INCOMING, consumer);
        this.inAdjacency.returnCursor(cursor);
    }

    @Override
    public void forEachOutgoing(int node, RelationshipConsumer consumer) {
        IntArray.Cursor cursor = this.cursor(node, this.outOffsets, this.outAdjacency);
        this.consumeNodes(node, cursor, RawValues.OUTGOING, consumer);
        this.outAdjacency.returnCursor(cursor);
    }

    private void forEachIncoming(int node, WeightedRelationshipConsumer consumer) {
        IntArray.Cursor cursor = this.cursor(node, this.inOffsets, this.inAdjacency);
        this.consumeNodes(node, cursor, RawValues.INCOMING, consumer);
        this.inAdjacency.returnCursor(cursor);
    }

    private void forEachOutgoing(int node, WeightedRelationshipConsumer consumer) {
        IntArray.Cursor cursor = this.cursor(node, this.outOffsets, this.outAdjacency);
        this.consumeNodes(node, cursor, RawValues.OUTGOING, consumer);
        this.outAdjacency.returnCursor(cursor);
    }

    private IntArray.Cursor cursor(int node, long[] offsets, IntArray array) {
        long offset = offsets[node];
        long length = offsets[node + 1] - offset;
        return array.cursorFor(offset, length);
    }

    private void consumeNodes(int startNode, IntArray.Cursor cursor, IdCombiner relId, WeightedRelationshipConsumer consumer) {
        WeightMapping weightMap = this.weightMapping;
        while (cursor.next()) {
            int[] array = cursor.array;
            int offset = cursor.offset;
            int limit = cursor.limit;
            while (offset < limit) {
                int targetNode = array[offset++];
                long relationId = relId.apply(startNode, targetNode);
                consumer.accept(startNode, targetNode, relationId, weightMap.get(relationId));
            }
        }
    }

    private void consumeNodes(int startNode, IntArray.Cursor cursor, IdCombiner relId, RelationshipConsumer consumer) {
        while (cursor.next()) {
            int[] array = cursor.array;
            int offset = cursor.offset;
            int limit = cursor.limit;
            while (offset < limit) {
                int targetNode = array[offset++];
                long relationId = relId.apply(startNode, targetNode);
                consumer.accept(startNode, targetNode, relationId);
            }
        }
    }

    @Override
    public void release() {
        if (this.inAdjacency != null) {
            this.inAdjacency.release();
            this.inAdjacency = null;
        }
        if (this.outAdjacency != null) {
            this.outAdjacency.release();
            this.outAdjacency = null;
        }
        this.weightMapping = null;
        this.inAdjacency = null;
        this.outAdjacency = null;
        this.inOffsets = null;
        this.outOffsets = null;
    }
}

