/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.lightweight;

import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.api.GraphSetup;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.lightweight.GraphImporter;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class LightGraphFactory
extends GraphFactory {
    public LightGraphFactory(GraphDatabaseAPI api, GraphSetup setup) {
        super(api, setup);
    }

    @Override
    public Graph build() {
        try {
            return this.importGraph();
        }
        catch (EntityNotFoundException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    private Graph importGraph() throws EntityNotFoundException {
        IdMap idMap = this.loadIdMap();
        GraphImporter graphImporter = new GraphImporter(this.api, this.setup, idMap, this.newWeightMap(this.dimensions.weightId(), this.setup.relationDefaultWeight), this.dimensions.nodeCount(), this.dimensions.relationId());
        return (Graph)graphImporter.call();
    }
}

