/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.lightweight;

import org.neo4j.graphalgo.api.WeightMapping;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.WeightMap;
import org.neo4j.graphalgo.core.lightweight.RelationshipImport;
import org.neo4j.graphalgo.core.utils.IdCombiner;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphalgo.core.utils.paged.IntArray;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;

class RelationshipImporter
implements RelationshipVisitor<EntityNotFoundException>,
RelationshipImport {
    final ReadOperations readOp;
    private final IdMap mapping;
    private final IntArray.BulkAdder bulkAdder;
    private final long[] offsets;
    private final int[] relationId;
    private final Direction direction;
    private int sourceGraphId;
    private long adjacencyIdx;
    private int imported;

    static RelationshipImporter of(ReadOperations readOp, IdMap mapping, long[] offsets, int[] relationId, Direction direction, IntArray.BulkAdder bulkAdder, WeightMapping weights) {
        if (weights instanceof WeightMap) {
            return new WithWeights(mapping, offsets, relationId, readOp, direction, (WeightMap)weights, bulkAdder);
        }
        return new RelationshipImporter(readOp, mapping, offsets, relationId, direction, bulkAdder);
    }

    RelationshipImporter(ReadOperations readOp, IdMap mapping, long[] offsets, int[] relationId, Direction direction, IntArray.BulkAdder bulkAdder) {
        this.readOp = readOp;
        this.mapping = mapping;
        this.direction = direction;
        this.bulkAdder = bulkAdder;
        this.offsets = offsets;
        this.relationId = relationId;
    }

    @Override
    public void importRelationships(int sourceGraphId, long sourceNodeId) throws EntityNotFoundException {
        int degree;
        this.imported = 0;
        this.offsets[sourceGraphId] = this.adjacencyIdx;
        int n = degree = this.relationId == null ? this.readOp.nodeGetDegree(sourceNodeId, this.direction) : this.readOp.nodeGetDegree(sourceNodeId, this.direction, this.relationId[0]);
        if (degree > 0) {
            RelationshipIterator rels = this.relationId == null ? this.readOp.nodeGetRelationships(sourceNodeId, this.direction) : this.readOp.nodeGetRelationships(sourceNodeId, this.direction, this.relationId);
            this.bulkAdder.init(this.adjacencyIdx, degree);
            this.sourceGraphId = sourceGraphId;
            while (rels.hasNext()) {
                long relId = rels.next();
                rels.relationshipVisit(relId, (RelationshipVisitor)this);
            }
        }
        this.adjacencyIdx += (long)this.imported;
    }

    int sourceGraphId() {
        return this.sourceGraphId;
    }

    long adjacencyIdx() {
        return this.adjacencyIdx;
    }

    public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.dovisit(relationshipId, typeId, startNodeId, endNodeId);
    }

    int dovisit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        long targetNodeId = this.direction == Direction.OUTGOING ? endNodeId : startNodeId;
        int targetGraphId = this.mapping.get(targetNodeId);
        if (targetGraphId == -1) {
            return -1;
        }
        this.bulkAdder.add(targetGraphId);
        ++this.imported;
        return targetGraphId;
    }

    static class WithWeights
    extends RelationshipImporter {
        private final WeightMap weights;
        private final int weightId;
        private final IdCombiner idCombiner;

        WithWeights(IdMap mapping, long[] offsets, int[] relationId, ReadOperations readOp, Direction direction, WeightMap weights, IntArray.BulkAdder bulkAdder) {
            super(readOp, mapping, offsets, relationId, direction, bulkAdder);
            this.weights = weights;
            this.weightId = weights.propertyId();
            this.idCombiner = RawValues.combiner(direction);
        }

        @Override
        int dovisit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
            int targetGraphId = super.dovisit(relationshipId, typeId, startNodeId, endNodeId);
            if (targetGraphId >= 0) {
                try {
                    Object value = this.readOp.relationshipGetProperty(relationshipId, this.weightId);
                    long relId = this.idCombiner.apply(this.sourceGraphId(), targetGraphId);
                    this.weights.set(relId, value);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    // empty catch block
                }
            }
            return targetGraphId;
        }
    }
}

