/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.neo4jview;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.api.WeightedRelationshipConsumer;
import org.neo4j.graphalgo.core.IdMap;
import org.neo4j.graphalgo.core.neo4jview.DirectIdMapping;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphView
implements Graph {
    private final ThreadToStatementContextBridge contextBridge;
    private final GraphDatabaseAPI db;
    private final double propertyDefaultWeight;
    private int relationTypeId;
    private int nodeCount;
    private int propertyKey;
    private int labelId;
    private final IdMapping idMapping;

    public GraphView(GraphDatabaseAPI db, String label, String relation, String propertyName, double propertyDefaultWeight) {
        this.db = db;
        this.contextBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        this.propertyDefaultWeight = propertyDefaultWeight;
        this.withinTransaction(read -> {
            this.labelId = read.labelGetForName(label);
            this.nodeCount = Math.toIntExact(read.countsForNode(this.labelId));
            this.relationTypeId = read.relationshipTypeGetForName(relation);
            this.propertyKey = read.propertyKeyGetForName(propertyName);
        });
        this.idMapping = this.createIdMapping();
    }

    private IdMapping createIdMapping() {
        if (this.labelId == -1) {
            return new DirectIdMapping(this.nodeCount);
        }
        IdMap idMap = new IdMap(this.nodeCount);
        this.withinTransaction(read -> {
            PrimitiveLongIterator it = read.nodesGetForLabel(this.labelId);
            while (it.hasNext()) {
                idMap.add(it.next());
            }
        });
        idMap.buildMappedIds();
        return idMap;
    }

    @Override
    public void forEachRelationship(int nodeId, Direction direction, RelationshipConsumer consumer) {
        WeightedRelationshipConsumer asWeighted = (sourceNodeId, targetNodeId, relationId, weight) -> consumer.accept(sourceNodeId, targetNodeId, relationId);
        this.forAllRelationships(nodeId, direction, false, asWeighted);
    }

    @Override
    public void forEachRelationship(int nodeId, Direction direction, WeightedRelationshipConsumer consumer) {
        this.forAllRelationships(nodeId, direction, true, consumer);
    }

    private void forAllRelationships(int nodeId, Direction direction, boolean readWeights, WeightedRelationshipConsumer action) {
        long originalNodeId = this.toOriginalNodeId(nodeId);
        try {
            this.withinTransaction(read -> {
                double defaultWeight = this.propertyDefaultWeight;
                RelationshipVisitor visitor = (relationshipId, typeId, startNodeId, endNodeId) -> {
                    long otherNodeId;
                    long l = otherNodeId = startNodeId == originalNodeId ? endNodeId : startNodeId;
                    if (this.idMapping.contains(otherNodeId)) {
                        double weight = defaultWeight;
                        if (readWeights && read.relationshipHasProperty(relationshipId, this.propertyKey)) {
                            Object value = read.relationshipGetProperty(relationshipId, this.propertyKey);
                            weight = RawValues.extractValue(value, defaultWeight);
                        }
                        int otherId = this.toMappedNodeId(otherNodeId);
                        long relId = RawValues.combineIntInt((int)startNodeId, (int)endNodeId);
                        action.accept(nodeId, otherId, relId, weight);
                    }
                };
                RelationshipIterator rels = this.relationTypeId == -1 ? read.nodeGetRelationships(originalNodeId, direction) : read.nodeGetRelationships(originalNodeId, direction, new int[]{this.relationTypeId});
                while (rels.hasNext()) {
                    long relId = rels.next();
                    rels.relationshipVisit(relId, visitor);
                }
            });
        }
        catch (EntityNotFoundException e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public void forEachNode(IntPredicate consumer) {
        this.withinTransaction(read -> {
            long nodeId;
            PrimitiveLongIterator nodes;
            PrimitiveLongIterator primitiveLongIterator = nodes = this.labelId == -1 ? read.nodesGetAll() : read.nodesGetForLabel(this.labelId);
            while (nodes.hasNext() && consumer.test(this.toMappedNodeId(nodeId = nodes.next()))) {
            }
        });
    }

    @Override
    public PrimitiveIntIterator nodeIterator() {
        return this.withinTransactionTyped(read -> {
            if (this.labelId == -1) {
                return new NodeIterator(this, read.nodesGetAll());
            }
            return new NodeIterator(this, read.nodesGetForLabel(this.labelId));
        });
    }

    @Override
    public Collection<PrimitiveIntIterable> batchIterables(int batchSize) {
        int nodeCount = this.nodeCount;
        int numberOfBatches = (int)Math.ceil((double)nodeCount / (double)batchSize);
        if (numberOfBatches == 1) {
            return Collections.singleton(this::nodeIterator);
        }
        PrimitiveIntIterable[] iterators = new PrimitiveIntIterable[numberOfBatches];
        Arrays.setAll(iterators, i -> () -> this.withinTransactionTyped(read -> {
            PrimitiveLongIterator neoIds = this.labelId == -1 ? read.nodesGetAll() : read.nodesGetForLabel(this.labelId);
            return new SizedNodeIterator(this, neoIds, i * batchSize, batchSize);
        }));
        return Arrays.asList(iterators);
    }

    @Override
    public int degree(int nodeId, Direction direction) {
        return this.withinTransactionInt(read -> {
            try {
                return read.nodeGetDegree(this.toOriginalNodeId(nodeId), direction, this.relationTypeId);
            }
            catch (EntityNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public int toMappedNodeId(long nodeId) {
        return this.idMapping.toMappedNodeId(nodeId);
    }

    @Override
    public long toOriginalNodeId(int nodeId) {
        return this.idMapping.toOriginalNodeId(nodeId);
    }

    @Override
    public boolean contains(long nodeId) {
        return this.idMapping.contains(nodeId);
    }

    /*
     * Exception decompiling
     */
    private int withinTransactionInt(ToIntFunction<ReadOperations> block) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private <T> T withinTransactionTyped(Function<ReadOperations, T> block) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <E extends Exception> void withinTransaction(CheckedConsumer<ReadOperations, E> block) throws E {
        try (Transaction tx = this.db.beginTx();
             Statement statement = this.contextBridge.get();){
            block.accept(statement.readOperations());
            tx.success();
        }
    }

    private static class SizedNodeIterator
    implements PrimitiveIntIterator {
        private final Graph graph;
        private final PrimitiveLongIterator iterator;
        private int remaining;

        private SizedNodeIterator(Graph graph, PrimitiveLongIterator iterator, int start, int length) {
            while (iterator.hasNext() && start-- > 0) {
                iterator.next();
            }
            this.graph = graph;
            this.iterator = iterator;
            this.remaining = length;
        }

        public boolean hasNext() {
            return this.remaining > 0 && this.iterator.hasNext();
        }

        public int next() {
            --this.remaining;
            return this.graph.toMappedNodeId(this.iterator.next());
        }
    }

    private static class NodeIterator
    implements PrimitiveIntIterator {
        private final Graph graph;
        private final PrimitiveLongIterator iterator;

        private NodeIterator(Graph graph, PrimitiveLongIterator iterator) {
            this.graph = graph;
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public int next() {
            return this.graph.toMappedNodeId(this.iterator.next());
        }
    }

    private static interface CheckedConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

