/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.sources;

import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.LongDoubleScatterMap;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipWeights;
import org.neo4j.graphalgo.core.sources.SingleRunAllRelationIterator;
import org.neo4j.graphalgo.core.utils.Importer;
import org.neo4j.graphalgo.core.utils.RawValues;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class BufferedWeightMap
implements RelationshipWeights {
    private final double propertyDefaultWeight;
    private final LongDoubleMap data;

    private BufferedWeightMap(LongDoubleMap data, double propertyDefaultWeight) {
        this.data = data;
        this.propertyDefaultWeight = propertyDefaultWeight;
    }

    @Override
    public double weightOf(int sourceNodeId, int targetNodeId) {
        return this.data.getOrDefault(RawValues.combineIntInt(sourceNodeId, targetNodeId), this.propertyDefaultWeight);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WeightImporter importer(GraphDatabaseAPI api) {
        return new WeightImporter(api);
    }

    public static class WeightImporter
    extends Importer<BufferedWeightMap, WeightImporter> {
        private IdMapping idMapping;
        private boolean anyDirection = false;

        public WeightImporter(GraphDatabaseAPI api) {
            super(api);
        }

        public WeightImporter withIdMapping(IdMapping idMapping) {
            this.idMapping = idMapping;
            return this;
        }

        public WeightImporter withAnyDirection(boolean anyDirection) {
            this.anyDirection = anyDirection;
            return this;
        }

        @Override
        protected WeightImporter me() {
            return this;
        }

        @Override
        protected BufferedWeightMap buildT() {
            Builder builder = BufferedWeightMap.builder().withAnyDirection(this.anyDirection);
            this.withinTransaction(readOp -> {
                RelationshipVisitor visitor;
                if (this.relationId == null) {
                    visitor = (relationshipId, typeId, startNodeId, endNodeId) -> {
                        try {
                            Object value = readOp.relationshipGetProperty(relationshipId, this.propertyId);
                            if (value != null) {
                                builder.withWeight(this.idMapping.toMappedNodeId(startNodeId), this.idMapping.toMappedNodeId(endNodeId), RawValues.extractValue(value, this.propertyDefaultValue));
                            }
                        }
                        catch (EntityNotFoundException entityNotFoundException) {
                            // empty catch block
                        }
                    };
                } else {
                    int targetType = this.relationId[0];
                    visitor = (relationshipId, typeId, startNodeId, endNodeId) -> {
                        if (typeId == targetType) {
                            try {
                                Object value = readOp.relationshipGetProperty(relationshipId, this.propertyId);
                                if (value != null) {
                                    builder.withWeight(this.idMapping.toMappedNodeId(startNodeId), this.idMapping.toMappedNodeId(endNodeId), RawValues.extractValue(value, this.propertyDefaultValue));
                                }
                            }
                            catch (EntityNotFoundException entityNotFoundException) {
                                // empty catch block
                            }
                        }
                    };
                }
                if (this.labelId == -1) {
                    this.readAllWeights((ReadOperations)readOp, (RelationshipVisitor<RuntimeException>)visitor);
                } else {
                    this.readLabelWeights((ReadOperations)readOp, (RelationshipVisitor<RuntimeException>)visitor, this.relationId);
                }
            });
            return builder.build();
        }

        private void readAllWeights(ReadOperations readOp, RelationshipVisitor<RuntimeException> visitor) {
            SingleRunAllRelationIterator.forAll(readOp, visitor);
        }

        private void readLabelWeights(ReadOperations readOp, RelationshipVisitor<RuntimeException> visitor, int[] relationId) {
            try {
                PrimitiveLongIterator nodes = readOp.nodesGetForLabel(this.labelId);
                while (nodes.hasNext()) {
                    long nodeId = nodes.next();
                    RelationshipIterator rels = relationId != null ? readOp.nodeGetRelationships(nodeId, Direction.BOTH, relationId) : readOp.nodeGetRelationships(nodeId, Direction.BOTH);
                    while (rels.hasNext()) {
                        long relId = rels.next();
                        rels.relationshipVisit(relId, visitor);
                    }
                }
            }
            catch (EntityNotFoundException e) {
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    }

    public static final class Builder {
        private final LongDoubleMap map = new LongDoubleScatterMap();
        private double propertyDefaultWeight = 0.0;
        private boolean anyDirection = false;

        public Builder withAnyDirection(boolean anyDirection) {
            this.anyDirection = anyDirection;
            return this;
        }

        public Builder withWeight(int sourceNodeId, int targetNodeId, double weight) {
            if (weight == this.propertyDefaultWeight) {
                return this;
            }
            this.map.put(RawValues.combineIntInt(sourceNodeId, targetNodeId), weight);
            if (this.anyDirection) {
                this.map.put(RawValues.combineIntInt(targetNodeId, sourceNodeId), weight);
            }
            return this;
        }

        public BufferedWeightMap build() {
            return new BufferedWeightMap(this.map, this.propertyDefaultWeight);
        }
    }
}

