/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.sources;

import com.carrotsearch.hppc.IntLongMap;
import com.carrotsearch.hppc.IntLongScatterMap;
import com.carrotsearch.hppc.LongIntMap;
import com.carrotsearch.hppc.LongIntScatterMap;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.core.utils.Importer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class LazyIdMapper
implements IdMapping {
    private final LongIntMap forward;
    private final IntLongMap backward;
    private final int nodeCount;
    private int current = 0;

    public LazyIdMapper() {
        this.forward = new LongIntScatterMap();
        this.backward = new IntLongScatterMap();
        this.nodeCount = -1;
    }

    public LazyIdMapper(int nodeCount) {
        this.forward = new LongIntScatterMap(nodeCount);
        this.backward = new IntLongScatterMap(nodeCount);
        this.nodeCount = nodeCount;
    }

    @Override
    public int toMappedNodeId(long nodeId) {
        int value = this.forward.getOrDefault(nodeId, -1);
        if (value != -1) {
            return value;
        }
        this.forward.put(nodeId, this.current);
        this.backward.put(this.current, nodeId);
        return this.current++;
    }

    @Override
    public long toOriginalNodeId(int nodeId) {
        return this.backward.getOrDefault(nodeId, -1L);
    }

    @Override
    public boolean contains(long nodeId) {
        return this.forward.containsKey(nodeId);
    }

    @Override
    public long nodeCount() {
        return this.nodeCount == -1 ? (long)this.forward.size() : (long)this.nodeCount;
    }

    public static LazyIdMapperImporter importer(GraphDatabaseAPI api) {
        return new LazyIdMapperImporter(api);
    }

    public static class LazyIdMapperImporter
    extends Importer<LazyIdMapper, LazyIdMapperImporter> {
        public LazyIdMapperImporter(GraphDatabaseAPI api) {
            super(api);
        }

        @Override
        protected LazyIdMapperImporter me() {
            return this;
        }

        @Override
        protected LazyIdMapper buildT() {
            return new LazyIdMapper(this.nodeCount);
        }
    }
}

