/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.sources;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphalgo.api.AllRelationshipIterator;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class SingleRunAllRelationIterator
implements AllRelationshipIterator {
    private final GraphDatabaseAPI api;
    private final IdMapping idMapping;

    public SingleRunAllRelationIterator(GraphDatabaseAPI api, IdMapping idMapping) {
        this.api = api;
        this.idMapping = idMapping;
    }

    @Override
    public void forEachRelationship(RelationshipConsumer consumer) {
        RelationshipVisitor visitor = (relationshipId, typeId, startNodeId, endNodeId) -> consumer.accept(this.idMapping.toMappedNodeId(startNodeId), this.idMapping.toMappedNodeId(endNodeId), relationshipId);
        try (Transaction transaction = this.api.beginTx();
             Statement statement = ((ThreadToStatementContextBridge)this.api.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).get();){
            ReadOperations readOperations = statement.readOperations();
            SingleRunAllRelationIterator.forAll(readOperations, (RelationshipVisitor<RuntimeException>)visitor);
            transaction.success();
        }
    }

    static void forAll(ReadOperations readOp, RelationshipVisitor<RuntimeException> visitor) {
        PrimitiveLongIterator allRels = readOp.relationshipsGetAll();
        if (allRels instanceof RelationshipIterator) {
            RelationshipIterator rels = (RelationshipIterator)allRels;
            while (rels.hasNext()) {
                rels.relationshipVisit(rels.next(), visitor);
            }
        } else {
            try {
                while (allRels.hasNext()) {
                    long relId = allRels.next();
                    readOp.relationshipVisit(relId, visitor);
                }
            }
            catch (EntityNotFoundException e) {
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    }
}

