/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicDoubleArray {
    private final AtomicIntegerArray data;
    private final double scaleFactor;

    public AtomicDoubleArray(int capacity, double scaleFactor) {
        this.data = new AtomicIntegerArray(capacity);
        this.scaleFactor = scaleFactor;
    }

    public boolean compareAndSwap(int index, double expected, double value) {
        return this.data.compareAndSet(index, (int)(expected * this.scaleFactor), (int)(value * this.scaleFactor));
    }

    public double fetchAndAdd(int index, double value) {
        return this.data.getAndAdd(index, (int)(value * this.scaleFactor));
    }

    public double fetchCAS(int index, double expected, double value) {
        int ret = this.data.get(index);
        this.compareAndSwap(index, expected, value);
        return ret;
    }

    public double get(int index) {
        return (double)this.data.get(index) / this.scaleFactor;
    }

    public void set(int index, double value) {
        this.data.set(index, (int)(value * this.scaleFactor));
    }

    public void add(int index, double value) {
        this.data.addAndGet(index, (int)(this.scaleFactor * value));
    }

    public void addExact(int index, double value) {
        int result;
        int expected;
        int newValue = (int)(value * this.scaleFactor);
        while (!this.data.compareAndSet(index, expected = this.data.get(index), result = Math.addExact(expected, newValue))) {
        }
    }

    public void addCapped(int index, double value) {
        int result;
        int expected;
        int newValue = (int)(value * this.scaleFactor);
        do {
            if ((result = (expected = this.data.get(index)) + newValue) >= expected) continue;
            result = Integer.MAX_VALUE;
        } while (!this.data.compareAndSet(index, expected, result));
    }

    public int length() {
        return this.data.length();
    }

    public void clear() {
        for (int i = this.data.length() - 1; i >= 0; --i) {
            this.data.set(i, 0);
        }
    }
}

