/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.BitUtil;

public final class ImportProgress {
    private final ProgressLogger progressLogger;
    private final AllocationTracker tracker;
    private final long nodeCount;
    private final long approxOperations;
    private final long progressMask;
    private final int relationProgressShift;
    private final AtomicLong nodeProgress;

    public ImportProgress(ProgressLogger progressLogger, AllocationTracker tracker, long nodeCount, long maxRelCount, boolean loadIncoming, boolean loadOutgoing) {
        this.progressLogger = progressLogger;
        this.tracker = tracker;
        this.nodeCount = nodeCount;
        long relOperations = (loadIncoming ? maxRelCount : 0L) + (loadOutgoing ? maxRelCount : 0L);
        long relFactor = BitUtil.nearbyPowerOfTwo(relOperations / nodeCount);
        this.relationProgressShift = Long.numberOfTrailingZeros(relFactor);
        this.approxOperations = nodeCount + (nodeCount << this.relationProgressShift);
        this.progressMask = (BitUtil.nearbyPowerOfTwo(nodeCount) >>> 6) - 1L;
        this.nodeProgress = new AtomicLong();
    }

    public void nodeProgress() {
        long nodes = this.nodeProgress.incrementAndGet();
        if ((nodes & this.progressMask) == 0L) {
            this.progressLogger.logProgress(nodes, this.approxOperations, this.tracker);
        }
    }

    public void relProgress() {
        long nodes = this.nodeProgress.incrementAndGet();
        if ((nodes & this.progressMask) == 0L) {
            this.progressLogger.logProgress((nodes << this.relationProgressShift) + this.nodeCount, this.approxOperations, this.tracker);
        }
    }

    public void resetForRelationships() {
        this.nodeProgress.set(0L);
    }
}

