/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class Importer<T, ME extends Importer<T, ME>> {
    public static final double DEFAULT_WEIGHT = 0.0;
    protected final GraphDatabaseAPI api;
    protected final ThreadToStatementContextBridge bridge;
    protected String label = null;
    protected String endLabel = null;
    protected String relationship = null;
    protected String property = null;
    protected double propertyDefaultValue = 0.0;
    protected int labelId = -1;
    protected int endLabelId = -1;
    protected int[] relationId = null;
    protected int propertyId = -1;
    protected int nodeCount = 0;

    public Importer(GraphDatabaseAPI api) {
        this.api = api;
        this.bridge = (ThreadToStatementContextBridge)api.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    public T build() {
        this.withinTransaction(readOp -> {
            int relId;
            this.labelId = this.loadAnyLabel() ? -1 : readOp.labelGetForName(this.label);
            int n = this.endLabelId = this.endLabel == null ? -1 : readOp.labelGetForName(this.label);
            if (!this.loadAnyRelationship() && (relId = readOp.relationshipTypeGetForName(this.relationship)) != -1) {
                this.relationId = new int[]{relId};
            }
            this.propertyId = this.loadAnyProperty() ? -1 : readOp.propertyKeyGetForName(this.property);
            this.nodeCount = Math.toIntExact(readOp.countsForNode(this.labelId));
        });
        return this.buildT();
    }

    public CompletableFuture<T> buildDelayed(ExecutorService executorService) {
        return CompletableFuture.supplyAsync(this::build, executorService);
    }

    public ME withLabel(String label) {
        this.label = Objects.requireNonNull(label);
        return this.me();
    }

    public ME withLabel(Label label) {
        this.label = Objects.requireNonNull(label).name();
        return this.me();
    }

    public ME withAnyLabel() {
        this.label = null;
        return this.me();
    }

    public ME withOptionalLabel(String label) {
        this.label = label;
        return this.me();
    }

    public ME withRelationshipType(String relationship) {
        this.relationship = Objects.requireNonNull(relationship);
        return this.me();
    }

    public ME withRelationshipType(RelationshipType relationship) {
        this.relationship = Objects.requireNonNull(relationship).name();
        return this.me();
    }

    public ME withAnyRelationshipType() {
        this.relationship = null;
        return this.me();
    }

    public ME withOptionalRelationshipType(String relation) {
        this.relationship = relation;
        return this.me();
    }

    public ME withWeightsFromProperty(String property, double propertyDefaultValue) {
        this.property = Objects.requireNonNull(property);
        this.propertyDefaultValue = propertyDefaultValue;
        return this.me();
    }

    public ME withOptionalWeightsFromProperty(String property, double propertyDefaultValue) {
        this.property = property;
        this.propertyDefaultValue = propertyDefaultValue;
        return this.me();
    }

    public ME withDefaultWeight(double propertyDefaultValue) {
        this.property = null;
        this.propertyDefaultValue = propertyDefaultValue;
        return this.me();
    }

    public ME withoutWeights() {
        this.property = null;
        this.propertyDefaultValue = 0.0;
        return this.me();
    }

    protected final void withinTransaction(Consumer<ReadOperations> block) {
        try (Transaction tx = this.api.beginTx();
             Statement statement = this.bridge.get();){
            block.accept(statement.readOperations());
            tx.success();
        }
    }

    protected void forEachNodeItem(ObjLongConsumer<ReadOperations> consumer) {
        try (Transaction tx = this.api.beginTx();
             Statement statement = this.bridge.get();){
            ReadOperations readOp = statement.readOperations();
            PrimitiveLongIterator nodes = this.labelId == -1 ? readOp.nodesGetAll() : readOp.nodesGetForLabel(this.labelId);
            while (nodes.hasNext()) {
                consumer.accept(readOp, nodes.next());
            }
            tx.success();
        }
    }

    public boolean loadAnyRelationship() {
        return this.relationship == null;
    }

    public boolean loadAnyLabel() {
        return this.label == null;
    }

    public boolean loadAnyProperty() {
        return this.property == null;
    }

    protected abstract ME me();

    protected abstract T buildT();
}

