/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphalgo.core.utils.ParallelUtil;

public final class LazyBatchCollection<T>
extends AbstractCollection<T> {
    private final boolean saveResults;
    private final BatchSupplier<T> supplier;
    private final long nodeCount;
    private final long batchSize;
    private final int numberOfBatches;
    private List<T> batches;

    public static <T> Collection<T> of(long nodeCount, long batchSize, BatchSupplier<T> supplier) {
        return new LazyBatchCollection<T>(batchSize, nodeCount, false, supplier);
    }

    public static <T> Collection<T> ofCached(long nodeCount, long batchSize, BatchSupplier<T> supplier) {
        return new LazyBatchCollection<T>(batchSize, nodeCount, true, supplier);
    }

    private LazyBatchCollection(long batchSize, long nodeCount, boolean saveResults, BatchSupplier<T> supplier) {
        this.saveResults = saveResults;
        this.supplier = supplier;
        this.nodeCount = nodeCount;
        this.batchSize = batchSize;
        this.numberOfBatches = Math.toIntExact(ParallelUtil.threadSize(batchSize, nodeCount));
    }

    @Override
    public final Iterator<T> iterator() {
        if (this.batches != null) {
            return this.batches.iterator();
        }
        if (this.saveResults) {
            this.batches = new ArrayList<T>(this.numberOfBatches);
        }
        return new AbstractIterator<T>(){
            private int i;
            private long start;

            @Override
            protected T fetch() {
                int i;
                if ((i = this.i++) >= LazyBatchCollection.this.numberOfBatches) {
                    return this.done();
                }
                long start = this.start;
                this.start += LazyBatchCollection.this.batchSize;
                long length = Math.min(LazyBatchCollection.this.batchSize, LazyBatchCollection.this.nodeCount - start);
                Object t = LazyBatchCollection.this.supplier.newBatch(start, length);
                if (LazyBatchCollection.this.batches != null) {
                    LazyBatchCollection.this.batches.add(t);
                }
                return t;
            }
        };
    }

    @Override
    public final int size() {
        if (this.batches != null) {
            return this.batches.size();
        }
        return this.numberOfBatches;
    }

    public static interface BatchSupplier<T> {
        public T newBatch(long var1, long var3);
    }
}

