/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveLongIterable;
import org.neo4j.graphalgo.api.BatchNodeIterable;
import org.neo4j.graphalgo.api.HugeBatchNodeIterable;
import org.neo4j.graphalgo.core.utils.HugeParallelGraphImporter;
import org.neo4j.graphalgo.core.utils.LazyMappingCollection;
import org.neo4j.graphalgo.core.utils.ParallelGraphImporter;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.helpers.Exceptions;

public final class ParallelUtil {
    public static final int DEFAULT_BATCH_SIZE = 10000;

    public static int threadSize(int batchSize, int elementCount) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + batchSize);
        }
        if (batchSize >= elementCount) {
            return 1;
        }
        return (int)Math.ceil((double)elementCount / (double)batchSize);
    }

    public static long threadSize(int batchSize, long elementCount) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + batchSize);
        }
        if ((long)batchSize >= elementCount) {
            return 1L;
        }
        return (long)Math.ceil((double)elementCount / (double)batchSize);
    }

    public static long threadSize(long batchSize, long elementCount) {
        if (batchSize <= 0L) {
            throw new IllegalArgumentException("Invalid batch size: " + batchSize);
        }
        if (batchSize >= elementCount) {
            return 1L;
        }
        return (long)Math.ceil((double)elementCount / (double)batchSize);
    }

    public static int adjustBatchSize(int nodeCount, int concurrency, int minBatchSize) {
        if (concurrency <= 0) {
            concurrency = nodeCount;
        }
        int targetBatchSize = ParallelUtil.threadSize(concurrency, nodeCount);
        return Math.max(minBatchSize, targetBatchSize);
    }

    public static long adjustBatchSize(long nodeCount, int concurrency, long minBatchSize) {
        if (concurrency <= 0) {
            concurrency = (int)Math.min(nodeCount, Integer.MAX_VALUE);
        }
        long targetBatchSize = ParallelUtil.threadSize(concurrency, nodeCount);
        return Math.max(minBatchSize, targetBatchSize);
    }

    public static boolean canRunInParallel(ExecutorService executor) {
        return executor != null && !executor.isShutdown() && !executor.isTerminated();
    }

    public static int availableThreads(ExecutorService executor, int desiredConcurrency) {
        if (!ParallelUtil.canRunInParallel(executor)) {
            return 0;
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor pool = (ThreadPoolExecutor)executor;
            int availableConcurrency = pool.getCorePoolSize() - pool.getActiveCount();
            return Math.min(availableConcurrency, desiredConcurrency);
        }
        return desiredConcurrency;
    }

    public static <T extends Runnable> List<T> readParallel(int concurrency, int batchSize, BatchNodeIterable idMapping, ParallelGraphImporter<T> importer, ExecutorService executor) {
        Collection<PrimitiveIntIterable> iterators = idMapping.batchIterables(batchSize);
        int threads = iterators.size();
        if (!ParallelUtil.canRunInParallel(executor) || threads == 1) {
            int nodeOffset = 0;
            ArrayList<T> tasks = new ArrayList<T>(threads);
            for (PrimitiveIntIterable iterator : iterators) {
                T task = importer.newImporter(nodeOffset, iterator);
                tasks.add(task);
                task.run();
                nodeOffset += batchSize;
            }
            return tasks;
        }
        ArrayList<T> tasks = new ArrayList<T>(threads);
        int nodeOffset = 0;
        for (PrimitiveIntIterable iterator : iterators) {
            tasks.add(importer.newImporter(nodeOffset, iterator));
            nodeOffset += batchSize;
        }
        ParallelUtil.runWithConcurrency(concurrency, tasks, executor);
        return tasks;
    }

    public static <T extends Runnable> void readParallel(int concurrency, int batchSize, HugeBatchNodeIterable idMapping, HugeParallelGraphImporter<T> importer, ExecutorService executor) {
        Collection<PrimitiveLongIterable> iterators = idMapping.hugeBatchIterables(batchSize);
        int threads = iterators.size();
        if (!ParallelUtil.canRunInParallel(executor) || threads == 1) {
            long nodeOffset = 0L;
            for (PrimitiveLongIterable iterator : iterators) {
                T task = importer.newImporter(nodeOffset, iterator);
                task.run();
                nodeOffset += (long)batchSize;
            }
        } else {
            AtomicLong nodeOffset = new AtomicLong();
            Collection<Runnable> tasks = LazyMappingCollection.of(iterators, it -> importer.newImporter(nodeOffset.getAndAdd(batchSize), (PrimitiveLongIterable)it));
            ParallelUtil.runWithConcurrency(concurrency, tasks, executor);
        }
    }

    public static void run(Collection<? extends Runnable> tasks, ExecutorService executor) {
        ParallelUtil.run(tasks, executor, null);
    }

    public static void run(Collection<? extends Runnable> tasks, ExecutorService executor, Collection<Future<?>> futures) {
        if (tasks.size() == 1) {
            tasks.iterator().next().run();
            return;
        }
        if (null == executor) {
            tasks.forEach(Runnable::run);
            return;
        }
        if (executor.isShutdown() || executor.isTerminated()) {
            throw new IllegalStateException("Executor is shut down");
        }
        if (futures == null) {
            futures = new ArrayList(tasks.size());
        } else {
            futures.clear();
        }
        for (Runnable runnable : tasks) {
            futures.add(executor.submit(runnable));
        }
        ParallelUtil.awaitTermination(futures);
    }

    public static void run(Collection<? extends Runnable> tasks, Runnable selfTask, ExecutorService executor, Collection<Future<?>> futures) {
        if (tasks.size() == 0) {
            selfTask.run();
            return;
        }
        if (null == executor) {
            tasks.forEach(Runnable::run);
            selfTask.run();
            return;
        }
        if (executor.isShutdown() || executor.isTerminated()) {
            throw new IllegalStateException("Executor is shut down");
        }
        if (futures == null) {
            futures = new ArrayList(tasks.size());
        } else {
            futures.clear();
        }
        for (Runnable runnable : tasks) {
            futures.add(executor.submit(runnable));
        }
        ParallelUtil.awaitTermination(futures);
    }

    public static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, ExecutorService executor) {
        ParallelUtil.runWithConcurrency(concurrency, tasks, 0L, 0, TerminationFlag.RUNNING_TRUE, executor);
    }

    public static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, TerminationFlag terminationFlag, ExecutorService executor) {
        ParallelUtil.runWithConcurrency(concurrency, tasks, 0L, 0, terminationFlag, executor);
    }

    public static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, long waitTime, TimeUnit timeUnit, ExecutorService executor) {
        ParallelUtil.runWithConcurrency(concurrency, tasks, timeUnit.toNanos(waitTime), Integer.MAX_VALUE, TerminationFlag.RUNNING_TRUE, executor);
    }

    public static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, long waitTime, TimeUnit timeUnit, TerminationFlag terminationFlag, ExecutorService executor) {
        ParallelUtil.runWithConcurrency(concurrency, tasks, timeUnit.toNanos(waitTime), Integer.MAX_VALUE, terminationFlag, executor);
    }

    public static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, int maxRetries, long waitTime, TimeUnit timeUnit, ExecutorService executor) {
        ParallelUtil.runWithConcurrency(concurrency, tasks, timeUnit.toNanos(waitTime), maxRetries, TerminationFlag.RUNNING_TRUE, executor);
    }

    public static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, int maxRetries, long waitTime, TimeUnit timeUnit, TerminationFlag terminationFlag, ExecutorService executor) {
        ParallelUtil.runWithConcurrency(concurrency, tasks, timeUnit.toNanos(waitTime), maxRetries, terminationFlag, executor);
    }

    /*
     * Exception decompiling
     */
    private static void runWithConcurrency(int concurrency, Collection<? extends Runnable> tasks, long waitNanos, int maxWaitRetries, TerminationFlag terminationFlag, ExecutorService executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void finishRunWithConcurrency(CompletionService completionService, Throwable error) {
        completionService.cancelAll();
        if (error != null) {
            throw Exceptions.launderedException((Throwable)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitTermination(Collection<Future<?>> futures) {
        Throwable error;
        block11: {
            boolean done = false;
            error = null;
            try {
                for (Future<?> future : futures) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException ee) {
                        error = Exceptions.chain((Throwable)error, (Throwable)ee.getCause());
                    }
                    catch (CancellationException cancellationException) {}
                }
                done = true;
            }
            catch (InterruptedException e) {
                error = Exceptions.chain((Throwable)e, error);
            }
            finally {
                if (done) break block11;
                for (Future<?> future : futures) {
                    future.cancel(true);
                }
            }
        }
        if (error != null) {
            throw Exceptions.launderedException((Throwable)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitTerminations(Queue<Future<?>> futures) {
        Throwable error;
        block11: {
            boolean done = false;
            error = null;
            try {
                while (!futures.isEmpty()) {
                    try {
                        futures.poll().get();
                    }
                    catch (ExecutionException ee) {
                        error = Exceptions.chain((Throwable)error, (Throwable)ee.getCause());
                    }
                    catch (CancellationException ee) {}
                }
                done = true;
            }
            catch (InterruptedException e) {
                error = Exceptions.chain((Throwable)e, error);
            }
            finally {
                if (done) break block11;
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        if (error != null) {
            throw Exceptions.launderedException((Throwable)error);
        }
    }

    public static void iterateParallel(ExecutorService executorService, int size, int concurrency, IntConsumer consumer) {
        ArrayList futures = new ArrayList();
        int batchSize = ParallelUtil.threadSize(concurrency, size);
        for (int i = 0; i < size; i += batchSize) {
            int start = i;
            int end = Math.min(size, start + batchSize);
            futures.add(executorService.submit(() -> {
                for (int j = start; j < end; ++j) {
                    consumer.accept(j);
                }
            }));
        }
        ParallelUtil.awaitTermination(futures);
    }

    private static final class PushbackIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> delegate;
        private T pushedElement;

        private PushbackIterator(Iterator<? extends T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.pushedElement != null || this.delegate.hasNext();
        }

        @Override
        public T next() {
            T el = this.pushedElement;
            if (el != null) {
                this.pushedElement = null;
            } else {
                el = this.delegate.next();
            }
            return el;
        }

        void pushBack(T element) {
            if (this.pushedElement != null) {
                throw new IllegalArgumentException("Cannot push back twice");
            }
            this.pushedElement = element;
        }
    }

    private static final class CompletionService {
        private final Executor executor;
        private final ThreadPoolExecutor pool;
        private final int availableConcurrency;
        private final Set<Future<Void>> running;
        private final BlockingQueue<Future<Void>> completionQueue;

        CompletionService(ExecutorService executor, int targetConcurrency) {
            if (!ParallelUtil.canRunInParallel(executor)) {
                throw new IllegalArgumentException("executor already terminated or not usable");
            }
            if (executor instanceof ThreadPoolExecutor) {
                this.pool = (ThreadPoolExecutor)executor;
                this.availableConcurrency = this.pool.getCorePoolSize();
                int capacity = Math.max(targetConcurrency, this.availableConcurrency) + 1;
                this.completionQueue = new ArrayBlockingQueue<Future<Void>>(capacity);
            } else {
                this.pool = null;
                this.availableConcurrency = Integer.MAX_VALUE;
                this.completionQueue = new LinkedBlockingQueue<Future<Void>>();
            }
            this.executor = executor;
            this.running = Collections.newSetFromMap(new ConcurrentHashMap());
        }

        boolean trySubmit(PushbackIterator<Runnable> tasks) {
            if (tasks.hasNext()) {
                Runnable next = tasks.next();
                if (this.submit(next)) {
                    return true;
                }
                tasks.pushBack(next);
            }
            return false;
        }

        boolean submit(Runnable task) {
            Objects.requireNonNull(task);
            if (this.canSubmit()) {
                QueueingFuture future = new QueueingFuture(task);
                this.executor.execute(future);
                return true;
            }
            return false;
        }

        boolean hasTasks() {
            return !this.running.isEmpty() || !this.completionQueue.isEmpty();
        }

        void awaitNext() throws InterruptedException, ExecutionException {
            this.completionQueue.take().get();
        }

        void cancelAll() {
            this.stopFuturesAndStopScheduling(this.running);
            this.stopFutures(this.completionQueue);
        }

        private boolean canSubmit() {
            return this.pool == null || this.pool.getActiveCount() < this.availableConcurrency;
        }

        private void stopFutures(Collection<Future<Void>> futures) {
            for (Future<Void> future : futures) {
                future.cancel(true);
            }
            futures.clear();
        }

        private void stopFuturesAndStopScheduling(Collection<Future<Void>> futures) {
            if (this.pool == null) {
                this.stopFutures(futures);
                return;
            }
            for (Future<Void> future : futures) {
                if (future instanceof Runnable) {
                    this.pool.remove((Runnable)((Object)future));
                }
                future.cancel(true);
            }
            futures.clear();
            this.pool.purge();
        }

        private class QueueingFuture
        extends FutureTask<Void> {
            QueueingFuture(Runnable runnable) {
                super(runnable, null);
                CompletionService.this.running.add(this);
            }

            @Override
            protected void done() {
                CompletionService.this.running.remove(this);
                if (!this.isCancelled()) {
                    while (!CompletionService.this.completionQueue.offer(this)) {
                    }
                }
            }
        }
    }
}

