/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.helpers.NamedThreadFactory;

public class Pools {
    public static final int DEFAULT_CONCURRENCY = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_QUEUE_SIZE = DEFAULT_CONCURRENCY * 50;
    public static final ExecutorService DEFAULT = Pools.createDefaultPool();

    private Pools() {
        throw new UnsupportedOperationException();
    }

    public static ExecutorService createDefaultPool() {
        return new ThreadPoolExecutor(DEFAULT_CONCURRENCY, DEFAULT_CONCURRENCY * 2, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(DEFAULT_QUEUE_SIZE), (ThreadFactory)NamedThreadFactory.daemon((String)"algo"), new CallerBlocksPolicy());
    }

    public static int getNoThreadsInDefaultPool() {
        return DEFAULT_CONCURRENCY;
    }

    static class CallerBlocksPolicy
    implements RejectedExecutionHandler {
        CallerBlocksPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                LockSupport.parkNanos(100L);
                try {
                    executor.submit(r).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

