/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.function.Supplier;
import org.neo4j.graphalgo.core.utils.ProgressLoggerAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public interface ProgressLogger {
    public static final ProgressLogger NULL_LOGGER = new ProgressLoggerAdapter((Log)NullLog.getInstance(), "NULL");
    public static final Supplier<String> NO_MESSAGE = () -> null;

    public static ProgressLogger wrap(Log log, String task) {
        return new ProgressLoggerAdapter(log, task);
    }

    public void logProgress(double var1, Supplier<String> var3);

    public void logDone(Supplier<String> var1);

    default public void logProgress(double numerator, double denominator, Supplier<String> msg) {
        this.logProgress(numerator / denominator, msg);
    }

    default public void logProgress(double numerator, double denominator) {
        this.logProgress(numerator, denominator, NO_MESSAGE);
    }

    default public void logProgress(double percentDone) {
        this.logProgress(percentDone, NO_MESSAGE);
    }

    default public void logDone() {
        this.logDone(NO_MESSAGE);
    }
}

