/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.logging.Log;

public class ProgressLoggerAdapter
implements ProgressLogger {
    private final Log log;
    private final String task;
    private int logIntervalMillis = 10000;
    private AtomicLong lastLog = new AtomicLong(0L);

    public ProgressLoggerAdapter(Log log, String task) {
        this.log = log;
        this.task = task;
    }

    @Override
    public void logProgress(double percentDone, Supplier<String> msgFactory) {
        long lastLogTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime > (lastLogTime = this.lastLog.get()) + (long)this.logIntervalMillis && this.lastLog.compareAndSet(lastLogTime, currentTime)) {
            this.doLog((int)(percentDone * 100.0), msgFactory);
        }
    }

    @Override
    public void logDone(Supplier<String> msgFactory) {
        this.doLog(100, msgFactory);
    }

    public void withLogIntervalMillis(int logIntervalMillis) {
        this.logIntervalMillis = logIntervalMillis;
    }

    private void doLog(int percent, Supplier<String> msgFactory) {
        String message;
        String string = message = msgFactory != ProgressLogger.NO_MESSAGE ? msgFactory.get() : null;
        if (message == null || message.isEmpty()) {
            this.log.info("[%s] %s %d%%", new Object[]{Thread.currentThread().getName(), this.task, percent});
        } else {
            this.log.info("[%s] %s %d%% %s", new Object[]{Thread.currentThread().getName(), this.task, percent, message});
        }
    }
}

