/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import org.neo4j.graphalgo.core.utils.IdCombiner;
import org.neo4j.graphdb.Direction;

public class RawValues {
    public static final IdCombiner OUTGOING = RawValues::combineIntInt;
    public static final IdCombiner INCOMING = (s, e) -> RawValues.combineIntInt(e, s);

    public static long combineIntInt(int head, int tail) {
        return (long)head << 32 | (long)tail & 0xFFFFFFFFL;
    }

    public static long combineIntInt(Direction direction, int head, int tail) {
        return direction == Direction.OUTGOING ? RawValues.combineIntInt(head, tail) : RawValues.combineIntInt(tail, head);
    }

    public static IdCombiner combiner(Direction direction) {
        return direction == Direction.OUTGOING ? OUTGOING : INCOMING;
    }

    public static int getHead(long combinedValue) {
        return (int)(combinedValue >> 32);
    }

    public static int getTail(long combinedValue) {
        return (int)combinedValue;
    }

    public static double extractValue(Object value, double propertyDefaultValue) {
        String s;
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String && !(s = (String)value).isEmpty()) {
            return Double.parseDouble(s);
        }
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            return 1.0;
        }
        return propertyDefaultValue;
    }
}

