/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

public interface RenamingRunnable
extends Runnable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void run() {
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        String newThreadName = this.threadName();
        boolean renamed = false;
        if (!oldThreadName.equals(newThreadName)) {
            try {
                currentThread.setName(newThreadName);
                renamed = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            this.doRun();
        }
        finally {
            if (renamed) {
                currentThread.setName(oldThreadName);
            }
        }
    }

    default public String threadName() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this);
    }

    public void doRun();
}

