/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils;

import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.kernel.api.KernelTransaction;

public class TerminationFlagImpl
implements TerminationFlag {
    private final KernelTransaction transaction;
    private long interval = 10000L;
    private volatile long lastCheck = 0L;
    private volatile boolean running = true;

    public TerminationFlagImpl(KernelTransaction transaction) {
        this.transaction = transaction;
    }

    public TerminationFlagImpl withCheckInterval(long interval) {
        this.interval = interval;
        return this;
    }

    @Override
    public boolean running() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastCheck + this.interval) {
            if (this.transaction.getReasonIfTerminated().isPresent() || !this.transaction.isOpen()) {
                this.running = false;
            }
            this.lastCheck = currentTime;
        }
        return this.running;
    }
}

