/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicBitSet {
    private final AtomicIntegerArray elements;

    public AtomicBitSet(int length) {
        this.elements = new AtomicIntegerArray(length + 31 >>> 5);
    }

    public void clear() {
        for (int i = this.elements.length() - 1; i >= 0; --i) {
            this.elements.set(i, 0);
        }
    }

    public void set(long n) {
        int value;
        int current;
        int bit = 1 << (int)n;
        int index = (int)(n >>> 5);
        while ((current = this.elements.get(index)) != (value = current | bit) && !this.elements.compareAndSet(index, current, value)) {
        }
    }

    public boolean trySet(long n) {
        int value;
        int current;
        int bit = 1 << (int)n;
        int index = (int)(n >>> 5);
        do {
            if ((current = this.elements.get(index)) != (value = current | bit)) continue;
            return false;
        } while (!this.elements.compareAndSet(index, current, value));
        return true;
    }

    public void unset(long n) {
        int value;
        int current;
        int bit = ~(1 << (int)n);
        int index = (int)(n >>> 5);
        while ((current = this.elements.get(index)) != (value = current & bit) && !this.elements.compareAndSet(index, current, value)) {
        }
    }

    public boolean get(long n) {
        int bit = 1 << (int)n;
        int index = (int)(n >>> 5);
        int value = this.elements.get(index);
        return (value & bit) != 0;
    }
}

