/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import java.util.Arrays;
import java.util.function.IntPredicate;

public class Buckets {
    private final int[] buckets;

    public Buckets(int capacity) {
        this.buckets = new int[capacity];
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.buckets, -1);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i] == -1) continue;
            return false;
        }
        return true;
    }

    public void set(int nodeId, int bucket) {
        this.buckets[nodeId] = bucket;
    }

    public int nextNonEmptyBucket() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.buckets.length; ++i) {
            int bucket = this.buckets[i];
            if (bucket == -1 || bucket >= min) continue;
            min = bucket;
        }
        return min;
    }

    public void forEachInBucket(int bucket, IntPredicate consumer) {
        for (int nodeId = 0; nodeId < this.buckets.length; ++nodeId) {
            int tb = this.buckets[nodeId];
            if (tb != bucket) continue;
            this.buckets[nodeId] = -1;
            if (consumer.test(nodeId)) continue;
            return;
        }
    }
}

