/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntStack;
import java.util.function.IntConsumer;

public class FlipStack {
    private final IntStack[] stacks;
    private int flip = 0;

    public FlipStack(int nodeCount) {
        this.stacks = new IntStack[]{new IntStack(nodeCount), new IntStack(nodeCount)};
    }

    public FlipStack(IntContainer nodes) {
        this(nodes.size());
        this.addAll(nodes);
    }

    public void reset() {
        this.flip = 0;
        this.pushStack().clear();
        this.popStack().clear();
    }

    public void flip() {
        ++this.flip;
    }

    public void addAll(IntContainer container) {
        this.pushStack().addAll(container);
    }

    public void push(int value) {
        this.pushStack().push(value);
    }

    public int pop() {
        return this.popStack().pop();
    }

    public boolean isEmpty() {
        return this.popStack().isEmpty();
    }

    public void forEach(IntConsumer consumer) {
        this.popStack().forEach(consumer::accept);
    }

    public IntStack pushStack() {
        return this.stacks[this.flip % 2];
    }

    public IntStack popStack() {
        return this.stacks[(this.flip + 1) % 2];
    }
}

