/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.IntConsumer;
import org.apache.lucene.util.ArrayUtil;

public class MultiQueue {
    private final AtomicIntegerArray offsets;
    private final int[][] queue;
    private final int nodeCount;
    private final ExecutorService executorService;

    public MultiQueue(ExecutorService executorService, int nodeCount) {
        this.executorService = executorService;
        this.nodeCount = nodeCount;
        this.offsets = new AtomicIntegerArray(nodeCount);
        this.queue = new int[nodeCount][];
    }

    public AtomicIntegerArray getOffsets() {
        return this.offsets;
    }

    public void clear(int phase) {
        this.offsets.set(phase, 0);
    }

    public void addOrCreate(int phase, int element) {
        if (this.offsets.get(phase) != 0) {
            int offset = this.offsets.getAndIncrement(phase);
            this.queue[phase] = ArrayUtil.grow((int[])this.queue[phase], (int)(offset + 1));
            this.queue[phase][offset] = element;
            return;
        }
        boolean done = false;
        while (!done) {
            int current = this.offsets.get(phase);
            done = this.offsets.compareAndSet(phase, current, current + 1);
            if (current == 0) {
                this.queue[phase] = new int[1];
            }
            this.queue[phase] = ArrayUtil.grow((int[])this.queue[phase], (int)(current + 1));
            this.queue[phase][current] = element;
        }
    }

    public void forEach(int phase, IntConsumer consumer) {
        int length = this.offsets.get(phase);
        for (int i = 0; i < length; ++i) {
            consumer.accept(this.queue[phase][i]);
        }
    }

    public void forEach(Collection<Future<?>> futures, int phase, IntConsumer consumer) {
        futures.add(this.executorService.submit(() -> {
            int length = this.offsets.get(phase);
            for (int i = 0; i < length; ++i) {
                consumer.accept(this.queue[phase][i]);
            }
        }));
    }
}

