/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import java.util.function.IntPredicate;
import org.apache.lucene.util.ArrayUtil;

public class Path {
    private int[] nodes;
    private int offset = 0;

    public Path() {
        this(10);
    }

    public Path(int initialSize) {
        this.nodes = new int[initialSize];
    }

    public void append(int nodeId) {
        this.nodes = ArrayUtil.grow((int[])this.nodes, (int)(this.offset + 1));
        this.nodes[this.offset++] = nodeId;
    }

    public int size() {
        return this.offset;
    }

    public void forEach(IntPredicate consumer) {
        for (int i = 0; i < this.offset; ++i) {
            if (consumer.test(this.nodes[i])) continue;
            return;
        }
    }

    public void clear() {
        this.offset = 0;
    }
}

