/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntObjectScatterMap;
import java.util.function.IntPredicate;
import org.neo4j.graphalgo.core.utils.container.Path;

public class Paths {
    public static final int INITIAL_PATH_CAPACITY = 100;
    private final IntObjectMap<Path> paths;

    public Paths() {
        this(10000);
    }

    public Paths(int expectedElements) {
        this.paths = new IntObjectScatterMap<Path>(expectedElements);
    }

    public void append(int pathId, int nodeId) {
        Path path;
        if (!this.paths.containsKey(pathId)) {
            path = new Path(100);
            this.paths.put(pathId, path);
        } else {
            path = this.paths.get(pathId);
        }
        path.append(nodeId);
    }

    public int size(int pathId) {
        return this.paths.containsKey(pathId) ? this.paths.get(pathId).size() : 0;
    }

    public void forEach(int pathId, IntPredicate consumer) {
        if (this.paths.containsKey(pathId)) {
            this.paths.get(pathId).forEach(consumer);
        }
    }

    public void clear() {
        this.paths.forEach(p -> ((Path)p.value).clear());
    }

    public void clear(int pathId) {
        Path path = this.paths.get(pathId);
        if (null != path) {
            path.clear();
        }
    }
}

