/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.core.utils.Importer;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class RelationshipContainer {
    private final int[][] data;

    private RelationshipContainer(int nodeCount) {
        this.data = new int[nodeCount][];
    }

    public void forEach(int nodeId, RelationshipConsumer consumer) {
        int[] relationships;
        if (nodeId >= this.data.length) {
            return;
        }
        for (int relationship : relationships = this.data[nodeId]) {
            consumer.accept(nodeId, relationship, -1L);
        }
    }

    public static Builder builder(int nodeCount) {
        return new Builder(nodeCount);
    }

    public static RCImporter importer(GraphDatabaseAPI api) {
        return new RCImporter(api);
    }

    private static final class RelVisitor
    implements RelationshipVisitor<RuntimeException> {
        private final Builder builder;
        private final IdMapping idMapping;
        private long neoId;

        private RelVisitor(Builder builder, IdMapping idMapping) {
            this.builder = builder;
            this.idMapping = idMapping;
        }

        public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) throws RuntimeException {
            long otherId = startNodeId == this.neoId ? endNodeId : startNodeId;
            this.builder.add(this.idMapping.toMappedNodeId(otherId));
        }
    }

    public static class RCImporter
    extends Importer<RelationshipContainer, RCImporter> {
        private IdMapping idMapping;
        private Direction direction;

        private RCImporter(GraphDatabaseAPI api) {
            super(api);
        }

        public RCImporter withIdMapping(IdMapping idMapping) {
            this.idMapping = idMapping;
            return this;
        }

        public RCImporter withDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        @Override
        protected RelationshipContainer buildT() {
            if (null == this.idMapping) {
                throw new IllegalArgumentException("No IdMapping given");
            }
            if (null == this.direction) {
                throw new IllegalArgumentException("No Direction given");
            }
            Builder builder = RelationshipContainer.builder(this.nodeCount);
            RelVisitor visitor = new RelVisitor(builder, this.idMapping);
            this.forEachNodeItem((read, nodeId) -> {
                try {
                    this.importNode(builder, nodeId, (ReadOperations)read, visitor);
                }
                catch (EntityNotFoundException e) {
                    throw Exceptions.launderedException((Throwable)e);
                }
            });
            return builder.build();
        }

        private void importNode(Builder builder, long neo4jId, ReadOperations read, RelVisitor visitor) throws EntityNotFoundException {
            RelationshipIterator rels;
            int nodeId = this.idMapping.toMappedNodeId(neo4jId);
            if (null == this.relationId) {
                builder.aim(nodeId, read.nodeGetDegree(neo4jId, this.direction));
                rels = read.nodeGetRelationships(neo4jId, this.direction);
            } else {
                builder.aim(nodeId, read.nodeGetDegree(neo4jId, this.direction, this.relationId[0]));
                rels = read.nodeGetRelationships(neo4jId, this.direction, this.relationId);
            }
            visitor.neoId = neo4jId;
            while (rels.hasNext()) {
                long relId = rels.next();
                rels.relationshipVisit(relId, (RelationshipVisitor)visitor);
            }
        }

        @Override
        protected RCImporter me() {
            return this;
        }
    }

    public static class Builder {
        private final RelationshipContainer container;
        private int nodeId;
        private int offset;

        private Builder(int nodeCount) {
            this.container = new RelationshipContainer(nodeCount);
        }

        public Builder aim(int nodeId, int degree) {
            this.nodeId = nodeId;
            this.offset = 0;
            ((RelationshipContainer)this.container).data[nodeId] = new int[degree];
            return this;
        }

        public Builder add(int targetNodeId) {
            ((RelationshipContainer)this.container).data[this.nodeId][this.offset++] = targetNodeId;
            return this;
        }

        public RelationshipContainer build() {
            return this.container;
        }
    }
}

