/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongDoubleHashMap;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.MemoryUsage;

public final class TrackingLongDoubleHashMap
extends LongDoubleHashMap {
    private final AllocationTracker tracker;

    public TrackingLongDoubleHashMap(AllocationTracker tracker) {
        super(4, 0.75, HashOrderMixing.defaultStrategy());
        this.tracker = tracker;
        this.trackBuffers(this.keys.length);
    }

    @Override
    protected void allocateBuffers(int arraySize) {
        if (!AllocationTracker.isTracking(this.tracker)) {
            super.allocateBuffers(arraySize);
            return;
        }
        int lengthBefore = this.keys.length;
        super.allocateBuffers(arraySize);
        int lengthAfter = this.keys.length;
        this.trackBuffers(-lengthBefore);
        this.trackBuffers(lengthAfter);
    }

    private void trackBuffers(int length) {
        this.tracker.add(MemoryUsage.sizeOfLongArray(length));
        this.tracker.add(MemoryUsage.sizeOfDoubleArray(length));
    }
}

