/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.container;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayDeque;
import java.util.Arrays;
import org.neo4j.graphalgo.api.RelationshipConsumer;

public class UndirectedTree {
    private static final int INVALID_NODE = -1;
    private static final long RELATION_ID_NOT_SUPPORTED = -1L;
    private final int[] children;
    private final int[] siblings;
    private final int capacity;
    private int size;

    public UndirectedTree(int capacity) {
        try {
            this.children = new int[capacity];
            this.siblings = new int[capacity];
        }
        catch (NegativeArraySizeException | OutOfMemoryError e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid capacity: " + capacity);
            iae.addSuppressed(e);
            throw iae;
        }
        Arrays.fill(this.children, -1);
        Arrays.fill(this.siblings, -1);
        this.capacity = capacity;
    }

    public void addRelationship(int node1, int node2) {
        if (node1 < node2) {
            this.addChild(node1, node2);
        } else if (node1 > node2) {
            this.addChild(node2, node1);
        }
    }

    public void removeRelationship(int node1, int node2) {
        if (node1 < node2) {
            this.removeChild(node1, node2);
        } else if (node1 > node2) {
            this.removeChild(node2, node1);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean nonEmpty() {
        return this.size > 0;
    }

    public void forEachBFS(int root, RelationshipConsumer consumer) {
        this.iterateBFS(root, consumer);
    }

    public void forEachDFS(int root, RelationshipConsumer consumer) {
        this.iterateDFS(root, consumer);
    }

    public void verifyTreeIntegrity() {
        BitSet seen = new BitSet(this.capacity);
        for (int child : this.children) {
            if (child == -1 || !seen.getAndSet(child)) continue;
            throw new IllegalStateException("node (" + child + ") has multiple parents");
        }
        for (int sibling : this.siblings) {
            if (sibling == -1 || !seen.getAndSet(sibling)) continue;
            throw new IllegalStateException("node (" + sibling + ") has multiple parents");
        }
    }

    private void addChild(int node1, int node2) {
        int sibling = this.children[node1];
        if (sibling != node2) {
            if (sibling != -1) {
                if (this.siblings[node2] != -1) {
                    throw new IllegalStateException("node (" + node2 + ") already has a parent");
                }
                this.siblings[node2] = sibling;
            }
            this.children[node1] = node2;
            ++this.size;
        }
    }

    private void removeChild(int node1, int node2) {
        int sibling = this.children[node1];
        if (sibling == node2) {
            this.children[node1] = this.siblings[node2];
            this.siblings[node2] = -1;
            --this.size;
        } else {
            this.removeSibling(sibling, node2);
        }
    }

    private void removeSibling(int node1, int node2) {
        int next;
        while ((next = this.siblings[node1]) != -1) {
            if (next == node2) {
                this.siblings[node1] = this.siblings[next];
                this.siblings[node2] = -1;
                --this.size;
                break;
            }
            node1 = next;
        }
    }

    private void iterateBFS(int startNode, RelationshipConsumer consumer) {
        IntArrayDeque queue = new IntArrayDeque();
        BitSet seen = new BitSet(this.capacity);
        queue.addFirst(startNode);
        while (!queue.isEmpty()) {
            int node = queue.removeFirst();
            int child = this.children[node];
            if (child == -1) continue;
            do {
                if (!seen.getAndSet(child)) {
                    queue.addLast(child);
                }
                if (consumer.accept(node, child, -1L)) continue;
                return;
            } while ((child = this.siblings[child]) != -1);
        }
    }

    private void iterateDFS(int node, RelationshipConsumer consumer) {
        int child = this.children[node];
        if (child != -1) {
            int sibling = child;
            do {
                if (!consumer.accept(node, sibling, -1L)) {
                    return;
                }
                this.iterateDFS(sibling, consumer);
            } while ((sibling = this.siblings[sibling]) != -1);
        }
    }
}

