/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.dss;

import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntIntScatterMap;
import com.carrotsearch.hppc.IntScatterSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.IdMapping;

public final class DisjointSetStruct {
    private final int[] parent;
    private final int[] depth;
    private final int capacity;

    public DisjointSetStruct(int capacity) {
        this.parent = new int[capacity];
        this.depth = new int[capacity];
        this.capacity = capacity;
    }

    public DisjointSetStruct merge(DisjointSetStruct other) {
        if (other.capacity != this.capacity) {
            throw new IllegalArgumentException("Different Capacity");
        }
        for (int i = other.parent.length - 1; i >= 0; --i) {
            if (other.parent[i] == -1) continue;
            this.union(i, other.find(i));
        }
        return this;
    }

    public DisjointSetStruct reset() {
        Arrays.fill(this.parent, -1);
        return this;
    }

    public void forEach(Consumer consumer) {
        for (int i = this.parent.length - 1; i >= 0 && consumer.consume(i, this.find(i)); --i) {
        }
    }

    public Iterator<Cursor> iterator() {
        return new NodeSetIterator(this);
    }

    public Iterator<Cursor> iterator(int start, int length) {
        return new ConcurrentNodeSetIterator(this, start, length);
    }

    public Stream<Result> resultStream(IdMapping idMapping) {
        return IntStream.range(0, (int)idMapping.nodeCount()).mapToObj(mappedId -> new Result(idMapping.toOriginalNodeId(mappedId), this.find(mappedId)));
    }

    public int count() {
        return this.parent.length;
    }

    public int find(int p) {
        return this.findPC(p);
    }

    public int findNoOpt(int p) {
        while (-1 != this.parent[p]) {
            p = this.parent[p];
        }
        return p;
    }

    public int findPH(int p) {
        while (-1 != this.parent[p]) {
            p = this.parent[p] = this.parent[this.parent[p]];
        }
        return p;
    }

    public int findPC(int p) {
        if (this.parent[p] == -1) {
            return p;
        }
        this.parent[p] = this.find(this.parent[p]);
        return this.parent[p];
    }

    public boolean connected(int p, int q) {
        return this.find(p) == this.find(q);
    }

    public void union(int p, int q) {
        int qSet;
        int pSet = this.find(p);
        if (pSet == (qSet = this.find(q))) {
            return;
        }
        int dp = this.depth[pSet];
        int dq = this.depth[qSet];
        if (dp < dq) {
            this.parent[pSet] = qSet;
        } else if (dp > dq) {
            this.parent[qSet] = pSet;
        } else {
            this.parent[qSet] = pSet;
            int n = pSet;
            this.depth[n] = this.depth[n] + (this.depth[qSet] + 1);
        }
    }

    public int getSetCount() {
        IntScatterSet set = new IntScatterSet();
        this.forEach((nodeId, setId) -> {
            set.add(setId);
            return true;
        });
        return set.size();
    }

    public IntIntMap getSetSize() {
        IntIntScatterMap map = new IntIntScatterMap();
        for (int i = this.parent.length - 1; i >= 0; --i) {
            map.addTo(this.find(i), 1);
        }
        return map;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        for (i = 0; i < this.count(); ++i) {
            builder.append(String.format(" %d ", i));
        }
        builder.append("\n");
        for (i = 0; i < this.count(); ++i) {
            builder.append(String.format("[%d]", this.find(i)));
        }
        return builder.toString();
    }

    public static class Result {
        public final Long nodeId;
        public final Long setId;

        public Result(long nodeId, int setId) {
            this.nodeId = nodeId;
            this.setId = setId;
        }
    }

    private static class ConcurrentNodeSetIterator
    implements Iterator<Cursor> {
        private final Cursor cursor = new Cursor();
        private final DisjointSetStruct struct;
        private final int length;
        private int offset = 0;

        private ConcurrentNodeSetIterator(DisjointSetStruct struct, int startOffset, int length) {
            this.struct = struct;
            this.length = length + this.offset > struct.count() ? struct.count() - this.offset : length;
            this.offset = startOffset;
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.length;
        }

        @Override
        public Cursor next() {
            this.cursor.nodeId = this.offset;
            this.cursor.setId = this.struct.findNoOpt(this.offset);
            return this.cursor;
        }
    }

    private static class NodeSetIterator
    implements Iterator<Cursor> {
        private final Cursor cursor = new Cursor();
        private final DisjointSetStruct struct;
        private final int length;
        private int offset = 0;

        private NodeSetIterator(DisjointSetStruct struct) {
            this.struct = struct;
            this.length = struct.count();
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.length;
        }

        @Override
        public Cursor next() {
            this.cursor.nodeId = this.offset;
            this.cursor.setId = this.struct.find(this.offset);
            return this.cursor;
        }
    }

    public static class Cursor {
        int nodeId;
        int setId;
    }

    @FunctionalInterface
    public static interface Consumer {
        public boolean consume(int var1, int var2);
    }
}

