/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class AllocationTracker
implements Supplier<String> {
    public static final AllocationTracker EMPTY = new AllocationTracker(){

        @Override
        public void add(long delta) {
        }

        @Override
        public void remove(long delta) {
        }

        @Override
        public long tracked() {
            return 0L;
        }

        @Override
        public String get() {
            return "";
        }

        @Override
        public String getUsageString() {
            return "";
        }

        @Override
        public String getUsageString(String label) {
            return "";
        }
    };
    private static final String[] UNITS = new String[]{" Bytes", " KiB", " MiB", " GiB", " TiB", " PiB", " EiB", " ZiB", " YiB"};
    private final AtomicLong count = new AtomicLong();

    public void add(long delta) {
        this.count.addAndGet(delta);
    }

    public void remove(long delta) {
        this.count.addAndGet(-delta);
    }

    public long tracked() {
        return this.count.get();
    }

    public String getUsageString() {
        return AllocationTracker.humanReadable(this.tracked());
    }

    public String getUsageString(String label) {
        return label + AllocationTracker.humanReadable(this.tracked());
    }

    @Override
    public String get() {
        return this.getUsageString("Memory usage: ");
    }

    public static AllocationTracker create() {
        return new AllocationTracker();
    }

    public static boolean isTracking(AllocationTracker tracker) {
        return tracker != null && tracker != EMPTY;
    }

    public static String humanReadable(long bytes) {
        for (String unit : UNITS) {
            if (bytes >> 14 == 0L) {
                return Long.toString(bytes) + unit;
            }
            bytes >>= 10;
        }
        return null;
    }
}

