/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

import java.util.concurrent.atomic.AtomicIntegerArray;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.MemoryUsage;
import org.neo4j.graphalgo.core.utils.paged.PageAllocator;
import org.neo4j.graphalgo.core.utils.paged.PageUtil;
import org.neo4j.graphalgo.core.utils.paged.PagedDataStructure;

public final class AtomicIntArray
extends PagedDataStructure<AtomicIntegerArray> {
    private static final PageAllocator.Factory<AtomicIntegerArray> ALLOCATOR_FACTORY;

    public static AtomicIntArray newArray(long size, AllocationTracker tracker) {
        return new AtomicIntArray(size, ALLOCATOR_FACTORY.newAllocator(tracker));
    }

    private AtomicIntArray(long size, PageAllocator<AtomicIntegerArray> allocator) {
        super(size, allocator);
    }

    public int get(long index) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return ((AtomicIntegerArray[])this.pages)[pageIndex].get(indexInPage);
    }

    public void set(long index, int value) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        ((AtomicIntegerArray[])this.pages)[pageIndex].set(indexInPage, value);
    }

    public void add(long index, int delta) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        ((AtomicIntegerArray[])this.pages)[pageIndex].addAndGet(indexInPage, delta);
    }

    public boolean cas(long index, int expected, int update) {
        assert (index < this.capacity());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return ((AtomicIntegerArray[])this.pages)[pageIndex].compareAndSet(indexInPage, expected, update);
    }

    static {
        int pageSize = PageUtil.pageSizeFor(4);
        long pageUsage = MemoryUsage.shallowSizeOfInstance(AtomicIntegerArray.class) + MemoryUsage.sizeOfIntArray(pageSize);
        ALLOCATOR_FACTORY = PageAllocator.of(pageSize, pageUsage, () -> new AtomicIntegerArray(pageSize), new AtomicIntegerArray[0]);
    }
}

