/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.core.utils.paged;

public final class BitUtil {
    public static boolean isPowerOfTwo(int value) {
        return value > 0 && (value & ~value + 1) == value;
    }

    public static int previousPowerOfTwo(int v) {
        int i = BitUtil.nextHighestPowerOfTwo(v);
        return i == v ? v : i >>> 1;
    }

    public static long previousPowerOfTwo(long v) {
        long i = BitUtil.nextHighestPowerOfTwo(v);
        return i == v ? v : i >>> 1;
    }

    public static int nearbyPowerOfTwo(int x) {
        int prev;
        int next = BitUtil.nextHighestPowerOfTwo(x);
        return next - x <= x - (prev = next >>> 1) ? next : prev;
    }

    public static long nearbyPowerOfTwo(long x) {
        long prev;
        long next = BitUtil.nextHighestPowerOfTwo(x);
        return next - x <= x - (prev = next >>> 1) ? next : prev;
    }

    public static int nextHighestPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static long nextHighestPowerOfTwo(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return ++v;
    }

    private BitUtil() {
        throw new UnsupportedOperationException("No instances");
    }
}

